/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.ShortArrayBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongColumnReader.class).instanceSize();
    private final Type type;
    private final OrcColumn column;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private short[] shortNonNullValueTemp = new short[0];
    private int[] intNonNullValueTemp = new int[0];
    private long[] longNonNullValueTemp = new long[0];
    private final LocalMemoryContext systemMemoryContext;

    public LongColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, t -> t instanceof BigintType || t instanceof IntegerType || t instanceof SmallintType || t instanceof DateType);
        this.type = type;
        this.column = Objects.requireNonNull(column, "column is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        if (this.type instanceof BigintType) {
            long[] values = new long[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new LongArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        if (this.type instanceof IntegerType || this.type instanceof DateType) {
            int[] values = new int[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new IntArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        if (this.type instanceof SmallintType) {
            short[] values = new short[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new ShortArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        if (this.type instanceof BigintType) {
            return this.longReadNullBlock(isNull, nonNullCount);
        }
        if (this.type instanceof IntegerType || this.type instanceof DateType) {
            return this.intReadNullBlock(isNull, nonNullCount);
        }
        if (this.type instanceof SmallintType) {
            return this.shortReadNullBlock(isNull, nonNullCount);
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private Block longReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.longNonNullValueTemp.length < minNonNullValueSize) {
            this.longNonNullValueTemp = new long[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((long[])this.longNonNullValueTemp));
        }
        this.dataStream.next(this.longNonNullValueTemp, nonNullCount);
        long[] result = ReaderUtils.unpackLongNulls(this.longNonNullValueTemp, isNull);
        return new LongArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block intReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.intNonNullValueTemp.length < minNonNullValueSize) {
            this.intNonNullValueTemp = new int[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((int[])this.intNonNullValueTemp));
        }
        this.dataStream.next(this.intNonNullValueTemp, nonNullCount);
        int[] result = ReaderUtils.unpackIntNulls(this.intNonNullValueTemp, isNull);
        return new IntArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block shortReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.shortNonNullValueTemp.length < minNonNullValueSize) {
            this.shortNonNullValueTemp = new short[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((short[])this.shortNonNullValueTemp));
        }
        this.dataStream.next(this.shortNonNullValueTemp, nonNullCount);
        short[] result = ReaderUtils.unpackShortNulls(this.shortNonNullValueTemp, isNull);
        return new ShortArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, ZoneId storageTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

