/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.reader.SliceColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectColumnReader.class).instanceSize();
    private static final int ONE_GIGABYTE = Math.toIntExact(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes());
    private final int maxCodePointCount;
    private final boolean isCharType;
    private final OrcColumn column;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private InputStreamSource<ByteArrayInputStream> dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nullable
    private ByteArrayInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDirectColumnReader(OrcColumn column, int maxCodePointCount, boolean isCharType) {
        this.maxCodePointCount = maxCodePointCount;
        this.isCharType = isCharType;
        this.column = Objects.requireNonNull(column, "column is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but length stream is missing");
                }
                long dataSkipSize = this.lengthStream.sum(this.readOffset);
                if (dataSkipSize > 0L) {
                    if (this.dataStream == null) {
                        throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                    }
                    this.dataStream.skip(dataSkipSize);
                }
            }
        }
        if (this.lengthStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            RunLengthEncodedBlock nullValueBlock = this.readAllNullsBlock();
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        boolean[] isNullVector = null;
        int[] offsetVector = new int[this.nextBatchSize + 1];
        if (this.presentStream == null) {
            this.lengthStream.next(offsetVector, this.nextBatchSize);
        } else {
            isNullVector = new boolean[this.nextBatchSize];
            int nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNullVector);
            if (nullCount == this.nextBatchSize) {
                RunLengthEncodedBlock nullValueBlock = this.readAllNullsBlock();
                this.readOffset = 0;
                this.nextBatchSize = 0;
                return nullValueBlock;
            }
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but length stream is missing");
            }
            if (nullCount == 0) {
                isNullVector = null;
                this.lengthStream.next(offsetVector, this.nextBatchSize);
            } else {
                this.lengthStream.next(offsetVector, this.nextBatchSize - nullCount);
                ReaderUtils.unpackLengthNulls(offsetVector, isNullVector, this.nextBatchSize - nullCount);
            }
        }
        long totalLength = 0L;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            totalLength += (long)offsetVector[i];
        }
        int currentBatchSize = this.nextBatchSize;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        if (totalLength == 0L) {
            return new VariableWidthBlock(currentBatchSize, Slices.EMPTY_SLICE, offsetVector, Optional.ofNullable(isNullVector));
        }
        if (totalLength > (long)ONE_GIGABYTE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.column.getPath(), this.nextBatchSize, this.column.getOrcDataSourceId()));
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
        }
        byte[] data = new byte[Math.toIntExact(totalLength)];
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (this.maxCodePointCount < 0) {
            this.dataStream.next(data, 0, data.length);
            ReaderUtils.convertLengthVectorToOffsetVector(offsetVector);
        } else {
            int currentLength = offsetVector[0];
            offsetVector[0] = 0;
            for (int i = 1; i <= currentBatchSize; ++i) {
                int nextLength = offsetVector[i];
                if (isNullVector != null && isNullVector[i - 1]) {
                    Preconditions.checkState((currentLength == 0 ? 1 : 0) != 0, (Object)"Corruption in slice direct stream: length is non-zero for null entry");
                    offsetVector[i] = offsetVector[i - 1];
                    currentLength = nextLength;
                    continue;
                }
                int offset = offsetVector[i - 1];
                this.dataStream.next(data, offset, offset + currentLength);
                int truncatedLength = SliceColumnReader.computeTruncatedLength(slice, offset, currentLength, this.maxCodePointCount, this.isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
                offsetVector[i] = offset + truncatedLength;
                currentLength = nextLength;
            }
        }
        return new VariableWidthBlock(currentBatchSize, slice, offsetVector, Optional.ofNullable(isNullVector));
    }

    private RunLengthEncodedBlock readAllNullsBlock() {
        return new RunLengthEncodedBlock((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[2], Optional.of(new boolean[]{true})), this.nextBatchSize);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, ZoneId storageTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataByteSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

