/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampColumnReader.class).instanceSize();
    private static final int MILLIS_PER_SECOND = 1000;
    private final OrcColumn column;
    private long baseTimestampInSeconds;
    @Nullable
    private DateTimeZone storageDateTimeZone;
    @Nullable
    private DateTimeZone fileDateTimeZone;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream secondsStream;
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream nanosStream;
    private boolean rowGroupOpen;
    private final LocalMemoryContext systemMemoryContext;

    public TimestampColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, TimestampType.class::isInstance);
        this.column = Objects.requireNonNull(column, "column is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
                }
                this.secondsStream.skip(this.readOffset);
                this.nanosStream.skip(this.readOffset);
            }
        }
        if (this.secondsStream == null && this.nanosStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)TimestampType.TIMESTAMP, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull) : RunLengthEncodedBlock.create((Type)TimestampType.TIMESTAMP, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        long[] values;
        block7: {
            int i;
            if (this.secondsStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
            }
            if (this.nanosStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
            }
            values = new long[this.nextBatchSize];
            for (i = 0; i < this.nextBatchSize; ++i) {
                values[i] = TimestampColumnReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
            }
            if (this.storageDateTimeZone == this.fileDateTimeZone) break block7;
            Verify.verify((this.storageDateTimeZone != null && this.fileDateTimeZone != null ? 1 : 0) != 0);
            if (this.fileDateTimeZone == DateTimeZone.UTC) {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    values[i] = this.storageDateTimeZone.convertLocalToUTC(values[i], false);
                }
            } else {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    values[i] = this.fileDateTimeZone.getMillisKeepLocal(this.storageDateTimeZone, values[i]);
                }
            }
        }
        return new LongArrayBlock(this.nextBatchSize, Optional.empty(), values);
    }

    private Block readNullBlock(boolean[] isNull) throws IOException {
        long[] values;
        block7: {
            int i;
            if (this.secondsStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
            }
            if (this.nanosStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
            }
            values = new long[isNull.length];
            for (i = 0; i < isNull.length; ++i) {
                if (isNull[i]) continue;
                values[i] = TimestampColumnReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
            }
            if (this.storageDateTimeZone == this.fileDateTimeZone) break block7;
            Verify.verify((this.storageDateTimeZone != null && this.fileDateTimeZone != null ? 1 : 0) != 0);
            if (this.fileDateTimeZone == DateTimeZone.UTC) {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    if (isNull[i]) continue;
                    values[i] = this.storageDateTimeZone.convertLocalToUTC(values[i], false);
                }
            } else {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    if (isNull[i]) continue;
                    values[i] = this.fileDateTimeZone.getMillisKeepLocal(this.storageDateTimeZone, values[i]);
                }
            }
        }
        return new LongArrayBlock(isNull.length, Optional.of(isNull), values);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, ZoneId storageTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        TimeZoneKey storageTimeZoneKey;
        this.baseTimestampInSeconds = ZonedDateTime.of(2015, 1, 1, 0, 0, 0, 0, fileTimeZone).toEpochSecond();
        TimeZoneKey fileTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)fileTimeZone.getId());
        if (fileTimeZoneKey.equals((Object)(storageTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)storageTimeZone.getId())))) {
            this.storageDateTimeZone = null;
            this.fileDateTimeZone = null;
        } else {
            this.storageDateTimeZone = DateTimeZone.forID((String)storageTimeZoneKey.getId());
            this.fileDateTimeZone = DateTimeZone.forID((String)fileTimeZoneKey.getId());
        }
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    private static long decodeTimestamp(long seconds, long serializedNanos, long baseTimestampInSeconds) {
        long millis = (seconds + baseTimestampInSeconds) * 1000L;
        long nanos = TimestampColumnReader.parseNanos(serializedNanos);
        if (nanos > 999999999L || nanos < 0L) {
            throw new IllegalArgumentException("nanos field of an encoded timestamp in ORC must be between 0 and 999999999 inclusive, got " + nanos);
        }
        if (millis < 0L && nanos != 0L) {
            millis -= 1000L;
        }
        return millis + nanos / 1000000L;
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

