/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.stream.OrcDataReader;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractDiskOrcDataReader
implements OrcDataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final int dataSize;
    private final int maxBufferSize;
    @Nullable
    private byte[] buffer;
    private int bufferSize;
    private int bufferStartPosition;

    public AbstractDiskOrcDataReader(OrcDataSourceId orcDataSourceId, int dataSize, int bufferSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.dataSize = dataSize;
        this.maxBufferSize = Math.min(bufferSize, dataSize);
    }

    @Override
    public final OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSourceId;
    }

    @Override
    public long getRetainedSize() {
        return this.buffer == null ? 0L : SizeOf.sizeOf((byte[])this.buffer);
    }

    @Override
    public final int getSize() {
        return this.dataSize;
    }

    @Override
    public final int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Override
    public final Slice seekBuffer(int newPosition) throws IOException {
        int newBufferSize = Math.min(this.dataSize - newPosition, this.maxBufferSize);
        if (this.buffer == null || this.buffer.length < newBufferSize) {
            this.buffer = new byte[newBufferSize];
        }
        if (newPosition > this.bufferStartPosition && newPosition < this.bufferStartPosition + this.bufferSize) {
            int overlapSize = this.bufferStartPosition + this.bufferSize - newPosition;
            System.arraycopy(this.buffer, this.bufferSize - overlapSize, this.buffer, 0, overlapSize);
            this.read(newPosition + overlapSize, this.buffer, overlapSize, newBufferSize - overlapSize);
        } else {
            this.read(newPosition, this.buffer, 0, newBufferSize);
        }
        this.bufferSize = newBufferSize;
        this.bufferStartPosition = newPosition;
        return Slices.wrappedBuffer((byte[])this.buffer, (int)0, (int)this.bufferSize);
    }

    public abstract void read(long var1, byte[] var3, int var4, int var5) throws IOException;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.orcDataSourceId).add("dataSize", this.dataSize).add("maxBufferSize", this.maxBufferSize).toString();
    }
}

