/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.MoreObjects;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.checkpoint.InputStreamCheckpoint;
import io.prestosql.orc.stream.OrcChunkLoader;
import io.prestosql.orc.stream.OrcDataReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class CompressedOrcChunkLoader
implements OrcChunkLoader {
    private final OrcDataReader dataReader;
    private final LocalMemoryContext dataReaderMemoryUsage;
    private final OrcDecompressor decompressor;
    private final LocalMemoryContext decompressionBufferMemoryUsage;
    private FixedLengthSliceInput compressedBufferStream = Slices.EMPTY_SLICE.getInput();
    private int compressedBufferStart;
    private int nextUncompressedOffset;
    private long lastCheckpoint;
    private byte[] decompressorOutputBuffer;

    public CompressedOrcChunkLoader(OrcDataReader dataReader, OrcDecompressor decompressor, AggregatedMemoryContext memoryContext) {
        this.dataReader = Objects.requireNonNull(dataReader, "dataReader is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.dataReaderMemoryUsage = memoryContext.newLocalMemoryContext(CompressedOrcChunkLoader.class.getSimpleName());
        this.dataReaderMemoryUsage.setBytes(dataReader.getRetainedSize());
        this.decompressionBufferMemoryUsage = memoryContext.newLocalMemoryContext(CompressedOrcChunkLoader.class.getSimpleName());
    }

    @Override
    public OrcDataSourceId getOrcDataSourceId() {
        return this.dataReader.getOrcDataSourceId();
    }

    private int getCurrentCompressedOffset() {
        return Math.toIntExact((long)this.compressedBufferStart + this.compressedBufferStream.position());
    }

    @Override
    public boolean hasNextChunk() {
        return this.getCurrentCompressedOffset() < this.dataReader.getSize();
    }

    @Override
    public long getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    @Override
    public void seekToCheckpoint(long checkpoint) throws IOException {
        int compressedOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        if (compressedOffset >= this.dataReader.getSize()) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Seek past end of stream");
        }
        if (this.compressedBufferStart <= compressedOffset && (long)compressedOffset < (long)this.compressedBufferStart + this.compressedBufferStream.length()) {
            this.compressedBufferStream.setPosition((long)(compressedOffset - this.compressedBufferStart));
        } else {
            this.compressedBufferStart = compressedOffset;
            this.compressedBufferStream = Slices.EMPTY_SLICE.getInput();
        }
        this.nextUncompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        this.lastCheckpoint = checkpoint;
    }

    @Override
    public Slice nextChunk() throws IOException {
        this.ensureCompressedBytesAvailable(3);
        this.lastCheckpoint = InputStreamCheckpoint.createInputStreamCheckpoint(this.getCurrentCompressedOffset(), this.nextUncompressedOffset);
        int b0 = this.compressedBufferStream.readUnsignedByte();
        int b1 = this.compressedBufferStream.readUnsignedByte();
        int b2 = this.compressedBufferStream.readUnsignedByte();
        boolean isUncompressed = (b0 & 1) == 1;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
        this.ensureCompressedBytesAvailable(chunkLength);
        Slice chunk = this.compressedBufferStream.readSlice(chunkLength);
        if (!isUncompressed) {
            int uncompressedSize = this.decompressor.decompress(chunk.byteArray(), chunk.byteArrayOffset(), chunk.length(), this.createOutputBuffer());
            chunk = Slices.wrappedBuffer((byte[])this.decompressorOutputBuffer, (int)0, (int)uncompressedSize);
        }
        if (this.nextUncompressedOffset != 0) {
            chunk = chunk.slice(this.nextUncompressedOffset, chunk.length() - this.nextUncompressedOffset);
            this.nextUncompressedOffset = 0;
            if (chunk.length() == 0) {
                chunk = this.nextChunk();
            }
        }
        return chunk;
    }

    private void ensureCompressedBytesAvailable(int size) throws IOException {
        if ((long)size <= this.compressedBufferStream.remaining()) {
            return;
        }
        if (size > this.dataReader.getMaxBufferSize()) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Requested read size (%s bytes) is greater than max buffer size (%s bytes", size, this.dataReader.getMaxBufferSize());
        }
        if ((long)this.compressedBufferStart + this.compressedBufferStream.position() + (long)size > (long)this.dataReader.getSize()) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Read past end of stream");
        }
        this.compressedBufferStart += Math.toIntExact(this.compressedBufferStream.position());
        Slice compressedBuffer = this.dataReader.seekBuffer(this.compressedBufferStart);
        this.dataReaderMemoryUsage.setBytes(this.dataReader.getRetainedSize());
        if (compressedBuffer.length() < size) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Requested read of %s bytes but only %s were bytes", size, compressedBuffer.length());
        }
        this.compressedBufferStream = compressedBuffer.getInput();
    }

    private OrcDecompressor.OutputBuffer createOutputBuffer() {
        return new OrcDecompressor.OutputBuffer(){

            @Override
            public byte[] initialize(int size) {
                if (CompressedOrcChunkLoader.this.decompressorOutputBuffer == null || size > CompressedOrcChunkLoader.this.decompressorOutputBuffer.length) {
                    CompressedOrcChunkLoader.access$002(CompressedOrcChunkLoader.this, new byte[size]);
                    CompressedOrcChunkLoader.this.decompressionBufferMemoryUsage.setBytes((long)CompressedOrcChunkLoader.this.decompressorOutputBuffer.length);
                }
                return CompressedOrcChunkLoader.this.decompressorOutputBuffer;
            }

            @Override
            public byte[] grow(int size) {
                if (size > CompressedOrcChunkLoader.this.decompressorOutputBuffer.length) {
                    CompressedOrcChunkLoader.access$002(CompressedOrcChunkLoader.this, Arrays.copyOfRange(CompressedOrcChunkLoader.this.decompressorOutputBuffer, 0, size));
                    CompressedOrcChunkLoader.this.decompressionBufferMemoryUsage.setBytes((long)CompressedOrcChunkLoader.this.decompressorOutputBuffer.length);
                }
                return CompressedOrcChunkLoader.this.decompressorOutputBuffer;
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("loader", (Object)this.dataReader).add("compressedOffset", this.getCurrentCompressedOffset()).add("decompressor", (Object)this.decompressor).toString();
    }

    static /* synthetic */ byte[] access$002(CompressedOrcChunkLoader x0, byte[] x1) {
        x0.decompressorOutputBuffer = x1;
        return x1;
    }
}

