/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.stream.OrcDataOutput;
import java.util.Objects;
import java.util.function.ToLongFunction;

public final class StreamDataOutput
implements OrcDataOutput,
Comparable<StreamDataOutput> {
    private final ToLongFunction<SliceOutput> writer;
    private final Stream stream;

    public StreamDataOutput(Slice slice, Stream stream) {
        this((SliceOutput sliceOutput) -> {
            sliceOutput.writeBytes(slice);
            return slice.length();
        }, stream);
    }

    public StreamDataOutput(ToLongFunction<SliceOutput> writer, Stream stream) {
        this.writer = Objects.requireNonNull(writer, "writer is null");
        this.stream = Objects.requireNonNull(stream, "stream is null");
    }

    @Override
    public int compareTo(StreamDataOutput otherStream) {
        return Long.compare(this.size(), otherStream.size());
    }

    @Override
    public long size() {
        return this.stream.getLength();
    }

    public Stream getStream() {
        return this.stream;
    }

    @Override
    public void writeData(SliceOutput sliceOutput) {
        long size = this.writer.applyAsLong(sliceOutput);
        Verify.verify(((long)this.stream.getLength() == size ? 1 : 0) != 0, (String)"Data stream did not write expected size", (Object[])new Object[0]);
    }
}

