/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.checkpoint.InputStreamCheckpoint;
import io.prestosql.orc.stream.OrcChunkLoader;
import io.prestosql.orc.stream.OrcDataReader;
import java.io.IOException;
import java.util.Objects;

public final class UncompressedOrcChunkLoader
implements OrcChunkLoader {
    private final OrcDataReader dataReader;
    private final LocalMemoryContext dataReaderMemoryUsage;
    private long lastCheckpoint;
    private int nextPosition;

    public UncompressedOrcChunkLoader(OrcDataReader dataReader, AggregatedMemoryContext memoryContext) {
        this.dataReader = Objects.requireNonNull(dataReader, "loader is null");
        Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.dataReaderMemoryUsage = memoryContext.newLocalMemoryContext(UncompressedOrcChunkLoader.class.getSimpleName());
        this.dataReaderMemoryUsage.setBytes(dataReader.getRetainedSize());
    }

    @Override
    public OrcDataSourceId getOrcDataSourceId() {
        return this.dataReader.getOrcDataSourceId();
    }

    private int getCurrentCompressedOffset() {
        return this.hasNextChunk() ? 0 : this.dataReader.getSize();
    }

    @Override
    public boolean hasNextChunk() {
        return this.nextPosition < this.dataReader.getSize();
    }

    @Override
    public long getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    @Override
    public void seekToCheckpoint(long checkpoint) throws OrcCorruptionException {
        int decompressedOffset;
        int compressedOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        if (compressedOffset != 0) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Uncompressed stream does not support seeking to a compressed offset");
        }
        this.nextPosition = decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        this.lastCheckpoint = checkpoint;
    }

    @Override
    public Slice nextChunk() throws IOException {
        if (this.nextPosition >= this.dataReader.getSize()) {
            throw new OrcCorruptionException(this.dataReader.getOrcDataSourceId(), "Read past end of stream");
        }
        Slice chunk = this.dataReader.seekBuffer(this.nextPosition);
        this.dataReaderMemoryUsage.setBytes(this.dataReader.getRetainedSize());
        this.lastCheckpoint = InputStreamCheckpoint.createInputStreamCheckpoint(0, this.nextPosition);
        this.nextPosition += chunk.length();
        return chunk;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("loader", (Object)this.dataReader).add("compressedOffset", this.getCurrentCompressedOffset()).toString();
    }
}

