/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.writer;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.statistics.BinaryStatisticsBuilder;
import io.prestosql.orc.metadata.statistics.DateStatisticsBuilder;
import io.prestosql.orc.metadata.statistics.IntegerStatisticsBuilder;
import io.prestosql.orc.writer.BooleanColumnWriter;
import io.prestosql.orc.writer.ByteColumnWriter;
import io.prestosql.orc.writer.ColumnWriter;
import io.prestosql.orc.writer.DecimalColumnWriter;
import io.prestosql.orc.writer.DoubleColumnWriter;
import io.prestosql.orc.writer.FloatColumnWriter;
import io.prestosql.orc.writer.ListColumnWriter;
import io.prestosql.orc.writer.LongColumnWriter;
import io.prestosql.orc.writer.MapColumnWriter;
import io.prestosql.orc.writer.SliceDictionaryColumnWriter;
import io.prestosql.orc.writer.SliceDirectColumnWriter;
import io.prestosql.orc.writer.StructColumnWriter;
import io.prestosql.orc.writer.TimestampColumnWriter;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public final class ColumnWriters {
    private ColumnWriters() {
    }

    public static ColumnWriter createColumnWriter(OrcColumnId columnId, ColumnMetadata<OrcType> orcTypes, Type type, CompressionKind compression, int bufferSize, DateTimeZone hiveStorageTimeZone, DataSize stringStatisticsLimit) {
        Objects.requireNonNull(type, "type is null");
        OrcType orcType = orcTypes.get(columnId);
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanColumnWriter(columnId, type, compression, bufferSize);
            }
            case FLOAT: {
                return new FloatColumnWriter(columnId, type, compression, bufferSize);
            }
            case DOUBLE: {
                return new DoubleColumnWriter(columnId, type, compression, bufferSize);
            }
            case BYTE: {
                return new ByteColumnWriter(columnId, type, compression, bufferSize);
            }
            case DATE: {
                return new LongColumnWriter(columnId, type, compression, bufferSize, DateStatisticsBuilder::new);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongColumnWriter(columnId, type, compression, bufferSize, IntegerStatisticsBuilder::new);
            }
            case DECIMAL: {
                return new DecimalColumnWriter(columnId, type, compression, bufferSize);
            }
            case TIMESTAMP: {
                return new TimestampColumnWriter(columnId, type, compression, bufferSize, hiveStorageTimeZone);
            }
            case BINARY: {
                return new SliceDirectColumnWriter(columnId, type, compression, bufferSize, BinaryStatisticsBuilder::new);
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return new SliceDictionaryColumnWriter(columnId, type, compression, bufferSize, stringStatisticsLimit);
            }
            case LIST: {
                OrcColumnId fieldColumnIndex = orcType.getFieldTypeIndex(0);
                Type fieldType = (Type)type.getTypeParameters().get(0);
                ColumnWriter elementWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, hiveStorageTimeZone, stringStatisticsLimit);
                return new ListColumnWriter(columnId, compression, bufferSize, elementWriter);
            }
            case MAP: {
                ColumnWriter keyWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), orcTypes, (Type)type.getTypeParameters().get(0), compression, bufferSize, hiveStorageTimeZone, stringStatisticsLimit);
                ColumnWriter valueWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(1), orcTypes, (Type)type.getTypeParameters().get(1), compression, bufferSize, hiveStorageTimeZone, stringStatisticsLimit);
                return new MapColumnWriter(columnId, compression, bufferSize, keyWriter, valueWriter);
            }
            case STRUCT: {
                ImmutableList.Builder fieldWriters = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    OrcColumnId fieldColumnIndex = orcType.getFieldTypeIndex(fieldId);
                    Type fieldType = (Type)type.getTypeParameters().get(fieldId);
                    fieldWriters.add((Object)ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, hiveStorageTimeZone, stringStatisticsLimit));
                }
                return new StructColumnWriter(columnId, compression, bufferSize, (List<ColumnWriter>)fieldWriters.build());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

