/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import com.google.common.base.Joiner;

public class Namespace {
    private static final Namespace EMPTY_NAMESPACE = new Namespace(new String[0]);
    private static final Joiner DOT = Joiner.on((char)'.');
    private final String[] levels;

    public static Namespace empty() {
        return EMPTY_NAMESPACE;
    }

    public static Namespace of(String ... levels) {
        if (levels.length == 0) {
            return Namespace.empty();
        }
        return new Namespace(levels);
    }

    private Namespace(String[] levels) {
        this.levels = levels;
    }

    public String[] levels() {
        return this.levels;
    }

    public String level(int pos) {
        return this.levels[pos];
    }

    public boolean isEmpty() {
        return this.levels.length == 0;
    }

    public String toString() {
        return DOT.join((Object[])this.levels);
    }
}

