/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.apache.iceberg.catalog.Namespace;

public class TableIdentifier {
    private static final Splitter DOT = Splitter.on((char)'.');
    private final Namespace namespace;
    private final String name;

    public static TableIdentifier of(String ... names) {
        Preconditions.checkArgument((names.length > 0 ? 1 : 0) != 0, (Object)"Cannot create table identifier without a table name");
        return new TableIdentifier(Namespace.of(Arrays.copyOf(names, names.length - 1)), names[names.length - 1]);
    }

    public static TableIdentifier of(Namespace namespace, String name) {
        return new TableIdentifier(namespace, name);
    }

    public static TableIdentifier parse(String identifier) {
        Iterable parts = DOT.split((CharSequence)identifier);
        return TableIdentifier.of((String[])Iterables.toArray((Iterable)parts, String.class));
    }

    private TableIdentifier(Namespace namespace, String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"Invalid table name %s", (Object)name);
        this.namespace = namespace;
        this.name = name;
    }

    public boolean hasNamespace() {
        return !this.namespace.isEmpty();
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.namespace.toString() + "." + this.name;
    }
}

