/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.Accessor;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Reference;
import org.apache.iceberg.types.Type;

public class BoundReference<T>
implements Reference {
    private final int fieldId;
    private final Accessor<StructLike> accessor;

    BoundReference(int fieldId, Accessor<StructLike> accessor) {
        this.fieldId = fieldId;
        this.accessor = accessor;
    }

    public Type type() {
        return this.accessor.type();
    }

    public int fieldId() {
        return this.fieldId;
    }

    public Accessor<StructLike> accessor() {
        return this.accessor;
    }

    public T get(StructLike struct) {
        return (T)this.accessor.get(struct);
    }

    public String toString() {
        return String.format("ref(id=%d, accessor-type=%s)", this.fieldId, this.accessor.type());
    }
}

