/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.Objects;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class UnknownTransform<S, T>
implements Transform<S, T> {
    private final Type sourceType;
    private final String transform;

    UnknownTransform(Type sourceType, String transform) {
        this.sourceType = sourceType;
        this.transform = transform;
    }

    @Override
    public T apply(S value) {
        throw new UnsupportedOperationException(String.format("Cannot apply unsupported transform: %s", this.transform));
    }

    @Override
    public boolean canTransform(Type type) {
        return this.sourceType.equals(type);
    }

    @Override
    public Type getResultType(Type type) {
        return Types.StringType.get();
    }

    @Override
    public UnboundPredicate<T> project(String name, BoundPredicate<S> predicate) {
        return null;
    }

    @Override
    public UnboundPredicate<T> projectStrict(String name, BoundPredicate<S> predicate) {
        return null;
    }

    public String toString() {
        return this.transform;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UnknownTransform that = (UnknownTransform)other;
        return this.sourceType.equals(that.sourceType) && this.transform.equals(that.transform);
    }

    public int hashCode() {
        return Objects.hash(this.sourceType, this.transform);
    }
}

