/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IndexByName
extends TypeUtil.SchemaVisitor<Map<String, Integer>> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Map<String, Integer> nameToId = Maps.newHashMap();

    @Override
    public Map<String, Integer> schema(Schema schema, Map<String, Integer> structResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> struct(Types.StructType struct, List<Map<String, Integer>> fieldResults) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> field(Types.NestedField field, Map<String, Integer> fieldResult) {
        this.addField(field.name(), field.fieldId());
        return null;
    }

    @Override
    public Map<String, Integer> list(Types.ListType list, Map<String, Integer> elementResult) {
        for (Types.NestedField field : list.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        return null;
    }

    @Override
    public Map<String, Integer> map(Types.MapType map, Map<String, Integer> keyResult, Map<String, Integer> valueResult) {
        for (Types.NestedField field : map.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        return null;
    }

    private void addField(String name, int fieldId) {
        String fullName = name;
        if (!this.fieldNames().isEmpty()) {
            fullName = DOT.join((Object)DOT.join(this.fieldNames().descendingIterator()), (Object)name, new Object[0]);
        }
        this.nameToId.put(fullName, fieldId);
    }
}

