/*
 * Decompiled with CFR 0.152.
 */
package com.google.shaded.common.shaded.cache;

import com.google.shaded.common.shaded.base.Preconditions;
import com.google.shaded.common.shaded.cache.RemovalListener;
import com.google.shaded.common.shaded.cache.RemovalNotification;
import java.util.concurrent.Executor;

public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

