/*
 * Decompiled with CFR 0.152.
 */
package com.google.shaded.common.shaded.collect;

import com.google.shaded.common.shaded.annotations.GwtCompatible;
import com.google.shaded.common.shaded.base.Preconditions;
import com.google.shaded.common.shaded.collect.AbstractIterator;
import com.google.shaded.common.shaded.collect.Lists;
import java.util.Collections;
import java.util.Queue;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = Lists.newLinkedList();
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

