/*
 * Decompiled with CFR 0.152.
 */
package com.google.shaded.shaded.common.cache;

import com.google.shaded.shaded.common.annotations.GwtCompatible;
import com.google.shaded.shaded.common.base.Objects;
import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.cache.RemovalCause;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible
public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    @Nullable
    private final K key;
    @Nullable
    private final V value;
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    public static <K, V> RemovalNotification<K, V> create(@Nullable K key, @Nullable V value, RemovalCause cause) {
        return new RemovalNotification<K, V>(key, value, cause);
    }

    private RemovalNotification(@Nullable K key, @Nullable V value, RemovalCause cause) {
        this.key = key;
        this.value = value;
        this.cause = Preconditions.checkNotNull(cause);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

