/*
 * Decompiled with CFR 0.152.
 */
package com.google.shaded.shaded.common.util.concurrent;

import com.google.shaded.shaded.common.annotations.Beta;
import com.google.shaded.shaded.common.annotations.GwtCompatible;
import com.google.shaded.shaded.common.annotations.GwtIncompatible;
import com.google.shaded.shaded.common.base.Function;
import com.google.shaded.shaded.common.base.Optional;
import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.collect.ImmutableCollection;
import com.google.shaded.shaded.common.collect.ImmutableList;
import com.google.shaded.shaded.common.collect.Lists;
import com.google.shaded.shaded.common.collect.Queues;
import com.google.shaded.shaded.common.util.concurrent.AbstractCheckedFuture;
import com.google.shaded.shaded.common.util.concurrent.AbstractFuture;
import com.google.shaded.shaded.common.util.concurrent.AsyncFunction;
import com.google.shaded.shaded.common.util.concurrent.CheckedFuture;
import com.google.shaded.shaded.common.util.concurrent.CollectionFuture;
import com.google.shaded.shaded.common.util.concurrent.ExecutionError;
import com.google.shaded.shaded.common.util.concurrent.FutureCallback;
import com.google.shaded.shaded.common.util.concurrent.FutureFallback;
import com.google.shaded.shaded.common.util.concurrent.FuturesGetChecked;
import com.google.shaded.shaded.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.shaded.shaded.common.util.concurrent.ListenableFuture;
import com.google.shaded.shaded.common.util.concurrent.MoreExecutors;
import com.google.shaded.shaded.common.util.concurrent.Platform;
import com.google.shaded.shaded.common.util.concurrent.SerializingExecutor;
import com.google.shaded.shaded.common.util.concurrent.SettableFuture;
import com.google.shaded.shaded.common.util.concurrent.UncheckedExecutionException;
import com.google.shaded.shaded.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Beta
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private static final AsyncFunction<ListenableFuture<Object>, Object> DEREFERENCER = new AsyncFunction<ListenableFuture<Object>, Object>(){

        @Override
        public ListenableFuture<Object> apply(ListenableFuture<Object> input) {
            return input;
        }
    };

    private Futures() {
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> future, Function<? super Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(future), mapper);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        if (value == null) {
            ImmediateSuccessfulFuture<Object> typedNull = ImmediateSuccessfulFuture.NULL;
            return typedNull;
        }
        return new ImmediateSuccessfulFuture<V>(value);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V value) {
        return new ImmediateSuccessfulCheckedFuture(value);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateCancelledFuture();
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(X exception) {
        Preconditions.checkNotNull(exception);
        return new ImmediateFailedCheckedFuture(exception);
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback) {
        return Futures.withFallback(input, fallback, MoreExecutors.directExecutor());
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback, Executor executor) {
        return Futures.catchingAsync(input, Throwable.class, Futures.asAsyncFunction(fallback), executor);
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
        CatchingFuture<? extends V, ? super X> future = new CatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.directExecutor());
        return future;
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        CatchingFuture<? extends V, ? super X> future = new CatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, Futures.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
        AsyncCatchingFuture<? extends V, ? super X> future = new AsyncCatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.directExecutor());
        return future;
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> future = new AsyncCatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, Futures.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    @Deprecated
    static <V> AsyncFunction<Throwable, V> asAsyncFunction(final FutureFallback<V> fallback) {
        Preconditions.checkNotNull(fallback);
        return new AsyncFunction<Throwable, V>(){

            @Override
            public ListenableFuture<V> apply(Throwable t) throws Exception {
                return Preconditions.checkNotNull(fallback.create(t), "FutureFallback.create returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            }
        };
    }

    @CheckReturnValue
    @GwtIncompatible(value="java.util.concurrent.ScheduledExecutorService")
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        TimeoutFuture.Fire<V> fire = new TimeoutFuture.Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, function);
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        return Futures.transformAsync(input, function, executor);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        AsyncChainingFuture<? super I, ? extends O> output = new AsyncChainingFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncChainingFuture<? super I, ? extends O> output = new AsyncChainingFuture<I, O>(input, function);
        input.addListener(output, Futures.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    private static Executor rejectionPropagatingExecutor(final Executor delegate, final AbstractFuture<?> future) {
        Preconditions.checkNotNull(delegate);
        if (delegate == MoreExecutors.directExecutor()) {
            return delegate;
        }
        return new Executor(){
            volatile boolean thrownFromDelegate = true;

            @Override
            public void execute(final Runnable command) {
                block2: {
                    try {
                        delegate.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate = false;
                                command.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        if (!this.thrownFromDelegate) break block2;
                        future.setException(e);
                    }
                }
            }
        };
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        ChainingFuture<? super I, ? extends O> output = new ChainingFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        ChainingFuture<? super I, ? extends O> output = new ChainingFuture<I, O>(input, function);
        input.addListener(output, Futures.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <I, O> Future<O> lazyTransform(final Future<I> input, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return input.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return input.isCancelled();
            }

            @Override
            public boolean isDone() {
                return input.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(input.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(input.get(timeout, unit));
            }

            private O applyTransformation(I input2) throws ExecutionException {
                try {
                    return function.apply(input2);
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> dereference(ListenableFuture<? extends ListenableFuture<? extends V>> nested) {
        return Futures.transformAsync(nested, DEREFERENCER);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        return new ListFuture<V>(ImmutableList.copyOf(futures), true);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(ImmutableList.copyOf(futures), true);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> future) {
        return new NonCancellationPropagatingFuture<V>(future);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... futures) {
        return new ListFuture<V>(ImmutableList.copyOf(futures), false);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(ImmutableList.copyOf(futures), false);
    }

    @CheckReturnValue
    @Beta
    @GwtIncompatible(value="TODO")
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        final ConcurrentLinkedQueue delegates = Queues.newConcurrentLinkedQueue();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        SerializingExecutor executor = new SerializingExecutor(MoreExecutors.directExecutor());
        for (final ListenableFuture<T> future : futures) {
            SettableFuture delegate = SettableFuture.create();
            delegates.add(delegate);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    ((SettableFuture)delegates.remove()).setFuture(future);
                }
            }, executor);
            listBuilder.add(delegate);
        }
        return listBuilder.build();
    }

    public static <V> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback) {
        Futures.addCallback(future, callback, MoreExecutors.directExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(callback);
        Runnable callbackListener = new Runnable(){

            @Override
            public void run() {
                Object value;
                try {
                    value = Uninterruptibles.getUninterruptibly(future);
                }
                catch (ExecutionException e) {
                    callback.onFailure(e.getCause());
                    return;
                }
                catch (RuntimeException e) {
                    callback.onFailure(e);
                    return;
                }
                catch (Error e) {
                    callback.onFailure(e);
                    return;
                }
                callback.onSuccess(value);
            }
        };
        future.addListener(callbackListener, executor);
    }

    @Deprecated
    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V get(Future<V> future, Class<X> exceptionClass) throws X {
        return Futures.getChecked(future, exceptionClass);
    }

    @Deprecated
    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V get(Future<V> future, long timeout, TimeUnit unit, Class<X> exceptionClass) throws X {
        return Futures.getChecked(future, exceptionClass, timeout, unit);
    }

    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass);
    }

    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass, timeout, unit);
    }

    @GwtIncompatible(value="TODO")
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static void wrapAndThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException(cause);
    }

    @GwtIncompatible(value="TODO")
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<? super Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> delegate, Function<? super Exception, X> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected X mapException(Exception e) {
            return (X)((Exception)this.mapper.apply(e));
        }
    }

    private static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new ListFutureRunningState(futures, allMustSucceed));
        }

        private final class ListFutureRunningState
        extends CollectionFuture.CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures, allMustSucceed);
            }

            public List<V> combine(List<Optional<V>> values) {
                ArrayList<Object> result = Lists.newArrayList();
                for (Optional element : values) {
                    result.add(element != null ? (Object)element.orNull() : null);
                }
                return Collections.unmodifiableList(result);
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        NonCancellationPropagatingFuture(final ListenableFuture<V> delegate) {
            delegate.addListener(new Runnable(){

                @Override
                public void run() {
                    NonCancellationPropagatingFuture.this.setFuture(delegate);
                }
            }, MoreExecutors.directExecutor());
        }
    }

    private static final class ChainingFuture<I, O>
    extends AbstractChainingFuture<I, O, Function<? super I, ? extends O>> {
        ChainingFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        void doTransform(Function<? super I, ? extends O> function, I input) {
            this.set(function.apply(input));
        }
    }

    private static final class AsyncChainingFuture<I, O>
    extends AbstractChainingFuture<I, O, AsyncFunction<? super I, ? extends O>> {
        AsyncChainingFuture(ListenableFuture<? extends I> inputFuture, AsyncFunction<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        void doTransform(AsyncFunction<? super I, ? extends O> function, I input) throws Exception {
            ListenableFuture<? extends O> outputFuture = function.apply(input);
            Preconditions.checkNotNull(outputFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            this.setFuture(outputFuture);
        }
    }

    private static abstract class AbstractChainingFuture<I, O, F>
    extends AbstractFuture.TrustedFuture<O>
    implements Runnable {
        @Nullable
        ListenableFuture<? extends I> inputFuture;
        @Nullable
        F function;

        AbstractChainingFuture(ListenableFuture<? extends I> inputFuture, F function) {
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public final void run() {
            try {
                I sourceResult;
                ListenableFuture<? extends I> localInputFuture = this.inputFuture;
                F localFunction = this.function;
                if (this.isCancelled() | localInputFuture == null | localFunction == null) {
                    return;
                }
                this.inputFuture = null;
                this.function = null;
                try {
                    sourceResult = Uninterruptibles.getUninterruptibly(localInputFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    return;
                }
                this.doTransform(localFunction, sourceResult);
            }
            catch (UndeclaredThrowableException e) {
                this.setException(e.getCause());
            }
            catch (Throwable t) {
                this.setException(t);
            }
        }

        abstract void doTransform(F var1, I var2) throws Exception;

        @Override
        final void done() {
            this.maybePropagateCancellation(this.inputFuture);
            this.inputFuture = null;
            this.function = null;
        }
    }

    private static final class TimeoutFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        @Nullable
        ListenableFuture<V> delegateRef;
        @Nullable
        Future<?> timer;

        TimeoutFuture(ListenableFuture<V> delegate) {
            this.delegateRef = Preconditions.checkNotNull(delegate);
        }

        @Override
        void done() {
            this.maybePropagateCancellation(this.delegateRef);
            Future<?> localTimer = this.timer;
            if (localTimer != null) {
                localTimer.cancel(false);
            }
            this.delegateRef = null;
            this.timer = null;
        }

        private static final class Fire<V>
        implements Runnable {
            @Nullable
            TimeoutFuture<V> timeoutFutureRef;

            Fire(TimeoutFuture<V> timeoutFuture) {
                this.timeoutFutureRef = timeoutFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeoutFuture timeoutFuture = this.timeoutFutureRef;
                if (timeoutFuture == null) {
                    return;
                }
                ListenableFuture delegate = timeoutFuture.delegateRef;
                if (delegate == null) {
                    return;
                }
                this.timeoutFutureRef = null;
                if (delegate.isDone()) {
                    timeoutFuture.setFuture(delegate);
                } else {
                    try {
                        timeoutFuture.setException(new TimeoutException("Future timed out: " + delegate));
                    }
                    finally {
                        delegate.cancel(true);
                    }
                }
            }
        }
    }

    static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>> {
        CatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        void doFallback(Function<? super X, ? extends V> fallback, X cause) throws Exception {
            V replacement = fallback.apply(cause);
            this.set(replacement);
        }
    }

    static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        void doFallback(AsyncFunction<? super X, ? extends V> fallback, X cause) throws Exception {
            ListenableFuture<? extends V> replacement = fallback.apply(cause);
            Preconditions.checkNotNull(replacement, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            this.setFuture(replacement);
        }
    }

    private static abstract class AbstractCatchingFuture<V, X extends Throwable, F>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        @Nullable
        ListenableFuture<? extends V> inputFuture;
        @Nullable
        Class<X> exceptionType;
        @Nullable
        F fallback;

        AbstractCatchingFuture(ListenableFuture<? extends V> inputFuture, Class<X> exceptionType, F fallback) {
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
            this.exceptionType = Preconditions.checkNotNull(exceptionType);
            this.fallback = Preconditions.checkNotNull(fallback);
        }

        @Override
        public final void run() {
            Throwable throwable;
            F localFallback;
            Class<X> localExceptionType;
            ListenableFuture<? extends V> localInputFuture = this.inputFuture;
            if (localInputFuture == null | (localExceptionType = this.exceptionType) == null | (localFallback = this.fallback) == null | this.isCancelled()) {
                return;
            }
            this.inputFuture = null;
            this.exceptionType = null;
            this.fallback = null;
            try {
                this.set(Uninterruptibles.getUninterruptibly(localInputFuture));
                return;
            }
            catch (ExecutionException e) {
                throwable = e.getCause();
            }
            catch (Throwable e) {
                throwable = e;
            }
            try {
                if (Platform.isInstanceOfThrowableClass(throwable, localExceptionType)) {
                    Throwable castThrowable = throwable;
                    this.doFallback(localFallback, castThrowable);
                } else {
                    this.setException(throwable);
                }
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }

        abstract void doFallback(F var1, X var2) throws Exception;

        @Override
        final void done() {
            this.maybePropagateCancellation(this.inputFuture);
            this.inputFuture = null;
            this.exceptionType = null;
            this.fallback = null;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateFailedCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        private final X thrown;

        ImmediateFailedCheckedFuture(X thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException((Throwable)this.thrown);
        }

        @Override
        public V checkedGet() throws X {
            throw this.thrown;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) throws X {
            Preconditions.checkNotNull(unit);
            throw this.thrown;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateCancelledFuture<V>
    extends ImmediateFuture<V> {
        private final CancellationException thrown = new CancellationException("Immediate cancelled future.");

        ImmediateCancelledFuture() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public V get() {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.thrown);
        }
    }

    private static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        ImmediateFailedFuture(Throwable thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateSuccessfulCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        @Nullable
        private final V value;

        ImmediateSuccessfulCheckedFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V checkedGet() {
            return this.value;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            return this.value;
        }
    }

    private static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        static final ImmediateSuccessfulFuture<Object> NULL = new ImmediateSuccessfulFuture<Object>(null);
        @Nullable
        private final V value;

        ImmediateSuccessfulFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            Preconditions.checkNotNull(listener, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(listener);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + listener + " with executor " + executor, e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long timeout, TimeUnit unit) throws ExecutionException {
            Preconditions.checkNotNull(unit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

