/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Ticker;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.cache.CacheLoader;
import com.google.shaded.shaded.common.cache.LoadingCache;
import com.google.shaded.shaded.common.cache.RemovalListener;
import com.google.shaded.shaded.common.cache.RemovalNotification;
import com.google.shaded.shaded.common.cache.Weigher;
import com.google.shaded.shaded.common.collect.ImmutableMap;
import com.google.shaded.shaded.common.util.concurrent.Service;
import com.qubole.rubix.bookkeeper.FileMetadata;
import com.qubole.rubix.bookkeeper.RemoteFetchProcessor;
import com.qubole.rubix.bookkeeper.exception.BookKeeperInitializationException;
import com.qubole.rubix.bookkeeper.utils.ConsistentHashUtil;
import com.qubole.rubix.bookkeeper.utils.DiskUtils;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.RemoteReadRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.FileInfo;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.thrift.ReadDataRequest;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.shaded.TException;

public abstract class BookKeeper
implements BookKeeperService.Iface {
    private static Log log = LogFactory.getLog(BookKeeper.class);
    protected static Cache<String, FileMetadata> fileMetadataCache;
    private static LoadingCache<String, FileInfo> fileInfoCache;
    String nodeName;
    protected final Configuration conf;
    static long splitSize;
    private RemoteFetchProcessor fetchProcessor;
    private final Ticker ticker;
    private static long totalAvailableForCache;
    protected final MetricRegistry metrics;
    private final BookKeeperMetrics bookKeeperMetrics;
    private static Counter cacheEvictionCount;
    private static Counter cacheInvalidationCount;
    private static Counter cacheExpiryCount;
    private Counter totalRequestCount;
    private Counter remoteRequestCount;
    private Counter cacheRequestCount;
    private Counter nonlocalRequestCount;

    public BookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws BookKeeperInitializationException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker());
    }

    @Override
    public boolean isBookKeeperAlive() {
        return true;
    }

    @VisibleForTesting
    BookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, Ticker ticker) throws BookKeeperInitializationException {
        this.conf = conf;
        this.bookKeeperMetrics = bookKeeperMetrics;
        this.metrics = bookKeeperMetrics.getMetricsRegistry();
        this.ticker = ticker;
        splitSize = CacheConfig.getCacheFileSplitSize(conf);
        this.cleanupOldCacheFiles(conf);
        this.setupCacheDirectory(conf);
        this.initializeMetrics();
        BookKeeper.initializeCache(conf, ticker);
        this.fetchProcessor = null;
        if (CacheConfig.isParallelWarmupEnabled(conf)) {
            this.fetchProcessor = new RemoteFetchProcessor(this, this.metrics, conf);
        }
    }

    private void setupCacheDirectory(Configuration conf) throws BookKeeperInitializationException {
        try {
            CacheUtil.createCacheDirectories(conf);
        }
        catch (FileNotFoundException ex) {
            throw new BookKeeperInitializationException(ex.toString(), ex);
        }
    }

    RemoteFetchProcessor getRemoteFetchProcessorInstance() {
        return this.fetchProcessor;
    }

    private void cleanupOldCacheFiles(Configuration conf) {
        if (CacheConfig.isCleanupFilesDuringStartEnabled(conf)) {
            try {
                int numDisks = CacheConfig.getCacheMaxDisks(conf);
                String dirSuffix = CacheConfig.getCacheDataDirSuffix(conf);
                List<String> dirPrefixList = CacheUtil.getDirPrefixList(conf);
                for (String dirPrefix : dirPrefixList) {
                    for (int i = 0; i < numDisks; ++i) {
                        java.nio.file.Path path = Paths.get(dirPrefix + i, dirSuffix, "*");
                        DiskUtils.clearDirectory(path.toString());
                    }
                    java.nio.file.Path path = Paths.get(dirPrefix, dirSuffix, "*");
                    DiskUtils.clearDirectory(path.toString());
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not clean up the old cached files", (Throwable)ex);
            }
        }
    }

    private void initializeMetrics() {
        cacheEvictionCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_EVICTION_COUNT.getMetricName());
        cacheInvalidationCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_INVALIDATION_COUNT.getMetricName());
        cacheExpiryCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_EXPIRY_COUNT.getMetricName());
        this.totalRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.TOTAL_REQUEST_COUNT.getMetricName());
        this.cacheRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_REQUEST_COUNT.getMetricName());
        this.nonlocalRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.NONLOCAL_REQUEST_COUNT.getMetricName());
        this.remoteRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.REMOTE_REQUEST_COUNT.getMetricName());
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_HIT_RATE_GAUGE.getMetricName(), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (double)BookKeeper.this.cacheRequestCount.getCount() / (double)(BookKeeper.this.cacheRequestCount.getCount() + BookKeeper.this.remoteRequestCount.getCount());
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_MISS_RATE_GAUGE.getMetricName(), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (double)BookKeeper.this.remoteRequestCount.getCount() / (double)(BookKeeper.this.cacheRequestCount.getCount() + BookKeeper.this.remoteRequestCount.getCount());
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_SIZE_GAUGE.getMetricName(), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return DiskUtils.getCacheSizeMB(BookKeeper.this.conf);
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_AVAILABLE_SIZE_GAUGE.getMetricName(), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return totalAvailableForCache;
            }
        });
    }

    @Override
    public List<BlockLocation> getCacheStatus(CacheStatusRequest request) throws TException {
        FileMetadata md;
        HashMap<Long, String> blockSplits = new HashMap<Long, String>();
        long blockNumber = 0L;
        long fileLength = request.getFileLength();
        String remotePath = request.getRemotePath();
        long lastModified = request.getLastModified();
        long startBlock = request.getStartBlock();
        long endBlock = request.getEndBlock();
        for (long i = 0L; i < fileLength; i += splitSize) {
            long end = i + splitSize;
            if (end > fileLength) {
                end = fileLength;
            }
            String key = remotePath + i + end;
            String hostName = this.getOwnerNodeForPath(key);
            blockSplits.put(blockNumber, hostName);
            ++blockNumber;
        }
        try {
            md = fileMetadataCache.get(remotePath, new CreateFileMetadataCallable(remotePath, fileLength, lastModified, 0L, this.conf));
            if (this.isInvalidationRequired(md.getLastModified(), lastModified)) {
                this.invalidateFileMetadata(remotePath);
                md = fileMetadataCache.get(remotePath, new CreateFileMetadataCallable(remotePath, fileLength, lastModified, 0L, this.conf));
            }
        }
        catch (ExecutionException e) {
            log.error((Object)String.format("Could not fetch Metadata for %s : %s", remotePath), (Throwable)e);
            throw new TException(e);
        }
        endBlock = this.setCorrectEndBlock(endBlock, fileLength, remotePath);
        ArrayList<BlockLocation> blockLocations = new ArrayList<BlockLocation>((int)(endBlock - startBlock));
        int blockSize = CacheConfig.getBlockSize(this.conf);
        int totalRequests = 0;
        int cacheRequests = 0;
        int remoteRequests = 0;
        int nonLocalRequests = 0;
        try {
            for (long blockNum = startBlock; blockNum < endBlock; ++blockNum) {
                ++totalRequests;
                long split = blockNum * (long)blockSize / splitSize;
                if (blockSplits.get(split) == null) {
                    blockLocations.add(new BlockLocation(Location.UNKNOWN, ""));
                    continue;
                }
                if (!((String)blockSplits.get(split)).equalsIgnoreCase(this.nodeName)) {
                    blockLocations.add(new BlockLocation(Location.NON_LOCAL, (String)blockSplits.get(split)));
                    ++nonLocalRequests;
                    continue;
                }
                if (md.isBlockCached(blockNum)) {
                    blockLocations.add(new BlockLocation(Location.CACHED, (String)blockSplits.get(split)));
                    ++cacheRequests;
                    continue;
                }
                blockLocations.add(new BlockLocation(Location.LOCAL, (String)blockSplits.get(split)));
                ++remoteRequests;
            }
        }
        catch (IOException e) {
            throw new TException(e);
        }
        if (request.isIncrMetrics() && !BookKeeper.isValidatingCachingBehavior(remotePath)) {
            this.totalRequestCount.inc(totalRequests);
            this.nonlocalRequestCount.inc(nonLocalRequests);
            this.cacheRequestCount.inc(cacheRequests);
            this.remoteRequestCount.inc(remoteRequests);
        }
        return blockLocations;
    }

    @Override
    public void setAllCached(SetCachedRequest request) throws TException {
        FileMetadata md = fileMetadataCache.getIfPresent(request.getRemotePath());
        if (md == null) {
            log.warn((Object)String.format("Could not update the metadata for file %s", request.getRemotePath()));
            return;
        }
        if (this.isInvalidationRequired(md.getLastModified(), request.getLastModified())) {
            this.invalidateFileMetadata(request.getRemotePath());
            return;
        }
        long endBlock = this.setCorrectEndBlock(request.getEndBlock(), request.getFileSize(), request.getRemotePath());
        log.debug((Object)("Updating cache for " + request.getRemotePath() + " StarBlock : " + request.getStartBlock() + " EndBlock : " + endBlock));
        try {
            md.setBlocksCached(request.getStartBlock(), endBlock);
            long currentFileSize = md.incrementCurrentFileSize((endBlock - request.getStartBlock()) * (long)CacheConfig.getBlockSize(this.conf));
            this.replaceFileMetadata(request.getRemotePath(), currentFileSize, this.conf);
        }
        catch (IOException e) {
            throw new TException(e);
        }
    }

    @Override
    public Map<String, Double> getCacheMetrics() {
        ImmutableMap.Builder<String, Double> cacheMetrics = ImmutableMap.builder();
        fileMetadataCache.cleanUp();
        for (Map.Entry<String, Gauge> entry : this.metrics.getGauges(this.bookKeeperMetrics.getMetricsFilter()).entrySet()) {
            try {
                cacheMetrics.put(entry.getKey(), this.getGaugeValueAsDouble(entry.getValue().getValue()));
            }
            catch (ClassCastException e) {
                log.error((Object)String.format("Gauge metric %s is not a numeric value", entry.getKey()), (Throwable)e);
            }
        }
        for (Map.Entry<String, Metric> entry : this.metrics.getCounters(this.bookKeeperMetrics.getMetricsFilter()).entrySet()) {
            cacheMetrics.put(entry.getKey(), Double.valueOf(((Counter)entry.getValue()).getCount()));
        }
        return cacheMetrics.build();
    }

    @Override
    public boolean readData(ReadDataRequest readDataRequest) throws TException {
        if (CacheConfig.isParallelWarmupEnabled(this.conf)) {
            this.startRemoteFetchProcessor();
            log.debug((Object)("Adding to the queue Path : " + readDataRequest.getRemotePath() + " Offset : " + readDataRequest.getReadStart() + " Length " + readDataRequest.getReadLength()));
            this.fetchProcessor.addToProcessQueue(readDataRequest.getRemotePath(), readDataRequest.getReadStart(), (int)readDataRequest.getReadLength(), readDataRequest.getFileSize(), readDataRequest.getLastModified());
            return true;
        }
        return this.readDataInternal(readDataRequest);
    }

    private synchronized void startRemoteFetchProcessor() {
        if (this.fetchProcessor.state() == Service.State.NEW) {
            this.fetchProcessor.startAsync();
        }
    }

    @Override
    public FileInfo getFileInfo(String remotePath) throws TException {
        if (CacheConfig.isFileStalenessCheckEnabled(this.conf)) {
            try {
                Path path = new Path(remotePath);
                FileSystem fs = path.getFileSystem(this.conf);
                FileStatus status = fs.getFileStatus(path);
                FileInfo info = new FileInfo(status.getLen(), status.getModificationTime());
                return info;
            }
            catch (Exception e) {
                log.error((Object)String.format("Could not fetch FileStatus from remote file system for %s : %s", remotePath), (Throwable)e);
            }
        } else {
            try {
                return fileInfoCache.get(remotePath);
            }
            catch (ExecutionException e) {
                log.error((Object)String.format("Could not fetch FileInfo from Cache for %s : %s", remotePath), (Throwable)e);
                throw new TException(e);
            }
        }
        return null;
    }

    @Override
    public abstract List<ClusterNode> getClusterNodes();

    @Override
    public String getOwnerNodeForPath(String remotePathKey) {
        List<ClusterNode> nodeList = this.getClusterNodes();
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        String hostName = ConsistentHashUtil.getHashedNodeForKey(nodeList, remotePathKey);
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readDataInternal(ReadDataRequest readDataRequest) throws TException {
        int blockSize = CacheConfig.getBlockSize(this.conf);
        byte[] buffer = new byte[blockSize];
        ByteBuffer byteBuffer = null;
        String remotePath = readDataRequest.getRemotePath();
        long offset = readDataRequest.getReadStart();
        long length = readDataRequest.getReadLength();
        long fileSize = readDataRequest.getFileSize();
        long lastModified = readDataRequest.getLastModified();
        String localPath = CacheUtil.getLocalPath(remotePath, this.conf);
        FileSystem fs = null;
        FSDataInputStream inputStream = null;
        Path path = new Path(remotePath);
        long startBlock = offset / (long)blockSize;
        long endBlock = (offset + (length - 1L)) / (long)CacheConfig.getBlockSize(this.conf) + 1L;
        try {
            int idx = 0;
            CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock);
            List<BlockLocation> blockLocations = this.getCacheStatus(request);
            long blockNum = startBlock;
            while (blockNum < endBlock) {
                long readStart = blockNum * (long)blockSize;
                log.debug((Object)(" blockLocation is: " + blockLocations.get(idx).getLocation() + " for path " + remotePath + " offset " + offset + " length " + length));
                if (blockLocations.get(idx).getLocation() != Location.CACHED) {
                    if (byteBuffer == null) {
                        byteBuffer = ByteBuffer.allocateDirect(CacheConfig.getDiskReadBufferSize(this.conf));
                    }
                    if (fs == null) {
                        fs = path.getFileSystem(this.conf);
                        fs.initialize(path.toUri(), this.conf);
                        inputStream = fs.open(path, blockSize);
                    }
                    long expectedBytesToRead = readStart + (long)blockSize > fileSize ? fileSize - readStart : (long)blockSize;
                    RemoteReadRequestChain remoteReadRequestChain = new RemoteReadRequestChain(inputStream, localPath, byteBuffer, buffer, new BookKeeperFactory(this));
                    remoteReadRequestChain.addReadRequest(new ReadRequest(readStart, readStart + (long)blockSize, readStart, readStart + (long)blockSize, buffer, 0, fileSize));
                    remoteReadRequestChain.lock();
                    Integer dataRead = remoteReadRequestChain.call();
                    if ((long)dataRead.intValue() == expectedBytesToRead) {
                        remoteReadRequestChain.updateCacheStatus(remotePath, fileSize, lastModified, blockSize, this.conf);
                    } else {
                        log.error((Object)("Not able to download requested bytes. Not updating the cache for block " + blockNum));
                        boolean bl = false;
                        return bl;
                    }
                }
                ++blockNum;
                ++idx;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn((Object)"Could not cache data: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    fs.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing inputStream", (Throwable)e);
                }
            }
        }
    }

    private long setCorrectEndBlock(long endBlock, long fileLength, String remotePath) {
        long lastBlock = (fileLength - 1L) / (long)CacheConfig.getBlockSize(this.conf);
        if (endBlock > lastBlock + 1L) {
            endBlock = lastBlock + 1L;
        }
        return endBlock;
    }

    private static synchronized void initializeCache(final Configuration conf, Ticker ticker) {
        long avail = 0L;
        for (int d = 0; d < CacheUtil.getCacheDiskCount(conf); ++d) {
            avail += new File(CacheUtil.getDirPath(d, conf)).getUsableSpace();
        }
        avail = DiskUtils.bytesToMB(avail);
        log.info((Object)("total free space " + avail + "MB"));
        long total = (long)(0.95 * (double)avail);
        long cacheMaxSize = CacheConfig.getCacheDataFullnessMaxSize(conf);
        totalAvailableForCache = cacheMaxSize == 0L ? (long)((double)total * 1.0 * (double)CacheConfig.getCacheDataFullnessPercentage(conf) / 100.0) : cacheMaxSize;
        BookKeeper.initializeFileInfoCache(conf, ticker);
        fileMetadataCache = CacheBuilder.newBuilder().ticker(ticker).weigher(new Weigher<String, FileMetadata>(){

            @Override
            public int weigh(String key, FileMetadata md) {
                return md.getWeight(conf);
            }
        }).maximumWeight(totalAvailableForCache).expireAfterWrite(CacheConfig.getCacheDataExpirationAfterWrite(conf), TimeUnit.MILLISECONDS).removalListener(new CacheRemovalListener()).build();
    }

    public FileMetadata getEntry(String key, Callable<FileMetadata> callable) throws ExecutionException {
        return fileMetadataCache.get(key, callable);
    }

    private static void initializeFileInfoCache(final Configuration conf, Ticker ticker) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int expiryPeriod = CacheConfig.getStaleFileInfoExpiryPeriod(conf);
        fileInfoCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(expiryPeriod, TimeUnit.SECONDS).removalListener(new RemovalListener<String, FileInfo>(){

            @Override
            public void onRemoval(RemovalNotification<String, FileInfo> notification) {
                log.debug((Object)("Removed FileInfo for path " + notification.getKey() + " due to " + (Object)((Object)notification.getCause())));
            }
        }).build(CacheLoader.asyncReloading(new CacheLoader<String, FileInfo>(){

            @Override
            public FileInfo load(String s) throws Exception {
                Path path = new Path(s);
                FileSystem fs = path.getFileSystem(conf);
                FileStatus status = fs.getFileStatus(path);
                FileInfo info = new FileInfo(status.getLen(), status.getModificationTime());
                return info;
            }
        }, executor));
    }

    @Override
    public void invalidateFileMetadata(String key) {
        FileMetadata metadata;
        if (fileMetadataCache != null && (metadata = fileMetadataCache.getIfPresent(key)) != null) {
            log.debug((Object)("Invalidating file " + key + " from metadata cache"));
            fileMetadataCache.invalidate(key);
        }
    }

    private void replaceFileMetadata(String key, long currentFileSize, Configuration conf) throws IOException {
        FileMetadata metadata;
        if (fileMetadataCache != null && (metadata = fileMetadataCache.getIfPresent(key)) != null) {
            FileMetadata newMetaData = new FileMetadata(key, metadata.getFileSize(), metadata.getLastModified(), currentFileSize, conf);
            fileMetadataCache.put(key, newMetaData);
        }
    }

    private boolean isInvalidationRequired(long metadataLastModifiedTime, long remoteLastModifiedTime) {
        return CacheConfig.isFileStalenessCheckEnabled(this.conf) && metadataLastModifiedTime != remoteLastModifiedTime;
    }

    private static boolean isValidatingCachingBehavior(String remotePath) {
        return "rubixCachingTestFile".equals(CacheUtil.getName(remotePath));
    }

    private double getGaugeValueAsDouble(Object gaugeValue) {
        if (gaugeValue instanceof Long) {
            return ((Long)gaugeValue).doubleValue();
        }
        if (gaugeValue instanceof Integer) {
            return ((Integer)gaugeValue).doubleValue();
        }
        if (Double.isNaN((Double)gaugeValue)) {
            return Double.NaN;
        }
        throw new ClassCastException("Could not cast gauge metric value type to Double");
    }

    private static class CreateFileMetadataCallable
    implements Callable<FileMetadata> {
        String path;
        Configuration conf;
        long fileLength;
        long lastModified;
        long currentFileSize;

        public CreateFileMetadataCallable(String path, long fileLength, long lastModified, long currentFileSize, Configuration conf) {
            this.path = path;
            this.conf = conf;
            this.fileLength = fileLength;
            this.lastModified = lastModified;
            this.currentFileSize = currentFileSize;
        }

        @Override
        public FileMetadata call() throws Exception {
            return new FileMetadata(this.path, this.fileLength, this.lastModified, this.currentFileSize, this.conf);
        }
    }

    protected static class CacheRemovalListener
    implements RemovalListener<String, FileMetadata> {
        protected CacheRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<String, FileMetadata> notification) {
            FileMetadata md = notification.getValue();
            try {
                md.closeAndCleanup(notification.getCause(), fileMetadataCache);
                if (!BookKeeper.isValidatingCachingBehavior(md.getRemotePath())) {
                    switch (notification.getCause()) {
                        case EXPLICIT: {
                            cacheInvalidationCount.inc();
                            break;
                        }
                        case SIZE: {
                            cacheEvictionCount.inc();
                            break;
                        }
                        case EXPIRED: {
                            cacheExpiryCount.inc();
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)("Could not cleanup FileMetadata for " + notification.getKey()), (Throwable)e);
            }
        }
    }
}

