/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.CoordinatorBookKeeper;
import com.qubole.rubix.bookkeeper.WorkerBookKeeper;
import com.qubole.rubix.bookkeeper.exception.BookKeeperInitializationException;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.common.metrics.BookKeeperMetricsFilter;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.thrift.shaded.server.TServer;
import org.apache.thrift.shaded.server.TThreadPoolServer;
import org.apache.thrift.shaded.transport.TServerSocket;
import org.apache.thrift.shaded.transport.TTransportException;

public class BookKeeperServer
extends Configured
implements Tool {
    public BookKeeperService.Processor processor;
    protected MetricRegistry metrics;
    protected BookKeeperMetrics bookKeeperMetrics;
    private BookKeeper localBookKeeper;
    public Configuration conf;
    private TServer server;
    private static Log log = LogFactory.getLog((String)BookKeeperServer.class.getName());

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new BookKeeperServer(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.conf = this.getConf();
        Runnable bookKeeperServer = new Runnable(){

            @Override
            public void run() {
                BookKeeperServer.this.startServer(BookKeeperServer.this.conf, new MetricRegistry());
            }
        };
        new Thread(bookKeeperServer).run();
        return 0;
    }

    public BookKeeper startServer(final Configuration conf, MetricRegistry metricsRegistry) {
        this.setupServer(conf, metricsRegistry);
        if (CacheConfig.isEmbeddedModeEnabled(conf)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BookKeeperServer.this.startThriftServer(conf, BookKeeperServer.this.localBookKeeper);
                }
            }).start();
        } else {
            this.startThriftServer(conf, this.localBookKeeper);
        }
        return this.localBookKeeper;
    }

    public void setupServer(Configuration conf, MetricRegistry metricsRegistry) {
        conf = new Configuration(conf);
        CacheConfig.setCacheDataEnabled(conf, false);
        CacheConfig.disableFSCaches(conf);
        this.metrics = metricsRegistry;
        this.bookKeeperMetrics = new BookKeeperMetrics(conf, this.metrics);
        this.registerMetrics(conf);
        try {
            this.localBookKeeper = CacheConfig.isOnMaster(conf) ? new CoordinatorBookKeeper(conf, this.bookKeeperMetrics) : new WorkerBookKeeper(conf, this.bookKeeperMetrics);
        }
        catch (BookKeeperInitializationException e) {
            log.error((Object)"Could not start BookKeeper daemon. Exception: ", (Throwable)e);
            throw Throwables.propagate(e);
        }
    }

    void startServer(Configuration conf, BookKeeper bookKeeper, BookKeeperMetrics bookKeeperMetrics) {
        conf = new Configuration(conf);
        CacheConfig.setCacheDataEnabled(conf, false);
        CacheConfig.disableFSCaches(conf);
        this.metrics = bookKeeperMetrics.getMetricsRegistry();
        this.bookKeeperMetrics = bookKeeperMetrics;
        this.registerMetrics(conf);
        this.startThriftServer(conf, bookKeeper);
    }

    private void startThriftServer(Configuration conf, BookKeeper bookKeeper) {
        this.processor = new BookKeeperService.Processor<BookKeeper>(bookKeeper);
        log.info((Object)("Starting BookKeeperServer on port " + CacheConfig.getBookKeeperServerPort(conf)));
        try {
            TServerSocket serverTransport = new TServerSocket((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().bindAddr(new InetSocketAddress(CacheConfig.getBookKeeperServerPort(conf)))).backlog(Integer.MAX_VALUE));
            this.server = new TThreadPoolServer(((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(this.processor)).maxWorkerThreads(CacheConfig.getServerMaxThreads(conf)));
            this.server.serve();
        }
        catch (TTransportException e) {
            log.error((Object)Throwables.getStackTraceAsString(e));
        }
    }

    protected void registerMetrics(Configuration conf) {
        this.metrics.register(BookKeeperMetrics.BookKeeperJvmMetric.BOOKKEEPER_JVM_GC_PREFIX.getMetricName(), new GarbageCollectorMetricSet());
        this.metrics.register(BookKeeperMetrics.BookKeeperJvmMetric.BOOKKEEPER_JVM_THREADS_PREFIX.getMetricName(), new CachedThreadStatesGaugeSet(CacheConfig.getMetricsReportingInterval(conf), TimeUnit.MILLISECONDS));
        this.metrics.register(BookKeeperMetrics.BookKeeperJvmMetric.BOOKKEEPER_JVM_MEMORY_PREFIX.getMetricName(), new MemoryUsageGaugeSet());
    }

    public void stopServer() {
        this.removeMetrics();
        try {
            this.bookKeeperMetrics.close();
        }
        catch (IOException e) {
            log.error((Object)"Metrics reporters could not be closed", (Throwable)e);
        }
        this.server.stop();
        log.info((Object)"Bookkeeper Server Stopped");
    }

    protected void removeMetrics() {
        BookKeeperMetricsFilter filter = this.bookKeeperMetrics.getMetricsFilter();
        this.metrics.removeMatching(filter);
    }

    @VisibleForTesting
    public boolean isServerUp() {
        if (this.server != null) {
            return this.server.isServing();
        }
        return false;
    }
}

