/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Gauge;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Ticker;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.exception.BookKeeperInitializationException;
import com.qubole.rubix.bookkeeper.exception.CoordinatorInitializationException;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.HeartbeatRequest;
import com.qubole.rubix.spi.thrift.HeartbeatStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class CoordinatorBookKeeper
extends BookKeeper {
    private static Log log = LogFactory.getLog((String)CoordinatorBookKeeper.class.getName());
    protected Cache<String, Boolean> liveWorkerCache;
    protected Cache<String, Boolean> cachingValidatedWorkerCache;
    protected Cache<String, Boolean> fileValidatedWorkerCache;
    private final boolean isValidationEnabled;
    private static Integer lock = 1;
    protected ClusterManager clusterManager;
    private int clusterType;

    public CoordinatorBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws BookKeeperInitializationException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker());
    }

    @VisibleForTesting
    public CoordinatorBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, Ticker ticker) throws BookKeeperInitializationException {
        super(conf, bookKeeperMetrics, ticker);
        this.isValidationEnabled = CacheConfig.isValidationEnabled(conf);
        this.liveWorkerCache = this.createHealthCache(conf, ticker);
        this.cachingValidatedWorkerCache = this.createHealthCache(conf, ticker);
        this.fileValidatedWorkerCache = this.createHealthCache(conf, ticker);
        this.clusterType = CacheConfig.getClusterType(conf);
        this.initializeCoordinator();
    }

    private void initializeCoordinator() throws CoordinatorInitializationException {
        this.initializeClusterManager();
        this.setCurrentNodeName();
        this.registerMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void initializeClusterManager() throws CoordinatorInitializationException {
        if (this.clusterManager == null) {
            ClusterManager manager = null;
            Integer n = lock;
            synchronized (n) {
                if (this.clusterManager == null) {
                    manager = this.getClusterManagerInstance(ClusterType.findByValue(this.clusterType), this.conf);
                    manager.initialize(this.conf);
                    this.clusterManager = manager;
                }
            }
        }
    }

    protected ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    private void setCurrentNodeName() {
        try {
            this.nodeName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Could not get Host Address", (Throwable)e);
            this.nodeName = ClusterUtil.getMasterHostname(this.conf);
        }
    }

    @VisibleForTesting
    protected ClusterManager getClusterManagerInstance(ClusterType clusterType, Configuration config) throws CoordinatorInitializationException {
        String clusterManagerClassName = CacheConfig.getClusterManagerClass(this.conf, clusterType);
        log.debug((Object)("Initializing cluster manager : " + clusterManagerClassName + " for cluster type " + (Object)((Object)clusterType)));
        ClusterManager manager = null;
        try {
            Class clusterManagerClass = this.conf.getClassByName(clusterManagerClassName);
            Constructor constructor = clusterManagerClass.getConstructor(new Class[0]);
            manager = (ClusterManager)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            String errorMessage = String.format("Not able to initialize ClusterManager class : %s ", clusterManagerClassName);
            log.error((Object)errorMessage);
            throw new CoordinatorInitializationException(errorMessage, ex);
        }
        return manager;
    }

    @Override
    public void handleHeartbeat(HeartbeatRequest request) {
        if (CacheConfig.isHeartbeatEnabled(this.conf) || !CacheConfig.isEmbeddedModeEnabled(this.conf)) {
            String workerHostname = request.getWorkerHostname();
            HeartbeatStatus heartbeatStatus = request.getHeartbeatStatus();
            this.liveWorkerCache.put(workerHostname, true);
            log.debug((Object)("Received heartbeat from " + workerHostname));
            if (this.isValidationEnabled) {
                if (heartbeatStatus.cachingValidationSucceeded) {
                    this.cachingValidatedWorkerCache.put(workerHostname, true);
                } else {
                    log.error((Object)String.format("Caching validation failed for worker node (hostname: %s)", workerHostname));
                }
                if (heartbeatStatus.fileValidationSucceeded) {
                    this.fileValidatedWorkerCache.put(workerHostname, true);
                } else {
                    log.error((Object)String.format("File validation failed for worker node (hostname: %s)", workerHostname));
                }
            }
        }
    }

    @Override
    public List<ClusterNode> getClusterNodes() {
        return this.getClusterManager().getNodes();
    }

    private void registerMetrics() {
        this.metrics.register(BookKeeperMetrics.HealthMetric.LIVE_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

            @Override
            public Long getValue() {
                CoordinatorBookKeeper.this.liveWorkerCache.cleanUp();
                log.debug((Object)String.format("Reporting %d live workers", CoordinatorBookKeeper.this.liveWorkerCache.size()));
                return CoordinatorBookKeeper.this.liveWorkerCache.size();
            }
        });
        if (this.isValidationEnabled) {
            this.metrics.register(BookKeeperMetrics.HealthMetric.CACHING_VALIDATED_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    CoordinatorBookKeeper.this.cachingValidatedWorkerCache.cleanUp();
                    log.debug((Object)String.format("Caching validation passed for %d workers", CoordinatorBookKeeper.this.cachingValidatedWorkerCache.size()));
                    return CoordinatorBookKeeper.this.cachingValidatedWorkerCache.size();
                }
            });
            this.metrics.register(BookKeeperMetrics.HealthMetric.FILE_VALIDATED_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    CoordinatorBookKeeper.this.fileValidatedWorkerCache.cleanUp();
                    log.debug((Object)String.format("File validation passed for %d workers", CoordinatorBookKeeper.this.fileValidatedWorkerCache.size()));
                    return CoordinatorBookKeeper.this.fileValidatedWorkerCache.size();
                }
            });
        }
    }

    private Cache<String, Boolean> createHealthCache(Configuration conf, Ticker ticker) {
        return CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(CacheConfig.getHealthStatusExpiry(conf), TimeUnit.MILLISECONDS).build();
    }
}

