/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileDownloadRequestChain
extends ReadRequestChain {
    private BookKeeper bookKeeper;
    private FileSystem remoteFileSystem;
    private String localFile;
    private String remotePath;
    private long fileSize;
    private long lastModified;
    private int totalRequestedRead;
    private int warmupPenalty;
    private int blockSize;
    Configuration conf;
    ByteBuffer directBuffer;
    private long timeSpentOnDownload;
    private static final Log log = LogFactory.getLog(FileDownloadRequestChain.class);

    public FileDownloadRequestChain(BookKeeper bookKeeper, FileSystem remoteFileSystem, String localfile, ByteBuffer directBuffer, Configuration conf, String remotePath, long fileSize, long lastModified) {
        this.bookKeeper = bookKeeper;
        this.remoteFileSystem = remoteFileSystem;
        this.localFile = localfile;
        this.conf = conf;
        this.remotePath = remotePath;
        this.fileSize = fileSize;
        this.lastModified = lastModified;
        this.blockSize = CacheConfig.getBlockSize(conf);
        this.directBuffer = directBuffer;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getTimeSpentOnDownload() {
        return this.timeSpentOnDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, FileDownload Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        Preconditions.checkState(this.isLocked(), "Trying to execute Chain without locking");
        List<ReadRequest> readRequests = this.getReadRequests();
        if (readRequests.size() == 0) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        File file = new File(this.localFile);
        if (!file.exists()) {
            log.debug((Object)("Creating localfile : " + this.localFile));
            String metadataFilePath = CacheUtil.getMetadataFilePath(this.remotePath, this.conf);
            File mdFile = new File(metadataFilePath);
            if (mdFile.exists() && mdFile.length() > 0L) {
                this.bookKeeper.invalidateFileMetadata(this.remotePath);
            }
            file.setWritable(true, false);
            file.setReadable(true, false);
            file.createNewFile();
        }
        FSDataInputStream inputStream = null;
        AbstractInterruptibleChannel fileChannel = null;
        FileSystem fileSystem = this.remoteFileSystem;
        try {
            inputStream = fileSystem.open(new Path(this.remotePath), CacheConfig.getBlockSize(this.conf));
            fileChannel = new FileOutputStream(new RandomAccessFile(file, "rw").getFD()).getChannel();
            for (ReadRequest readRequest : readRequests) {
                if (this.isCancelled()) {
                    log.debug((Object)("Request Cancelled for " + readRequest.getBackendReadStart()));
                    this.propagateCancel(this.getClass().getName());
                }
                int readBytes = 0;
                inputStream.seek(readRequest.getBackendReadStart());
                log.debug((Object)("Seeking to " + readRequest.getBackendReadStart()));
                readBytes = this.copyIntoCache(inputStream, (FileChannel)fileChannel, readRequest.getBackendReadLength(), readRequest.getBackendReadStart());
                this.totalRequestedRead += readBytes;
            }
            long endTime = System.currentTimeMillis();
            this.timeSpentOnDownload = (endTime - startTime) / 1000L;
            log.debug((Object)("Downloaded " + this.totalRequestedRead + " bytes of file " + this.remotePath));
            log.debug((Object)("RemoteFetchRequest took : " + this.timeSpentOnDownload + " secs "));
            Integer n = this.totalRequestedRead;
            return n;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            fileSystem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyIntoCache(FSDataInputStream inputStream, FileChannel fileChannel, int length, long cacheReadStart) throws IOException {
        int nread;
        byte[] buffer = null;
        try {
            int nwrite;
            int nbytes;
            long start = System.nanoTime();
            buffer = new byte[length];
            log.debug((Object)("Copying data of file " + this.remotePath + " of length " + length + " from offset " + cacheReadStart));
            for (nread = 0; nread < length && (nbytes = inputStream.read(buffer, nread, length - nread)) >= 0; nread += nbytes) {
            }
            int writtenSoFar = 0;
            for (int leftToWrite = length; leftToWrite > 0; leftToWrite -= nwrite) {
                int writeInThisCycle = Math.min(leftToWrite, this.directBuffer.capacity());
                this.directBuffer.clear();
                this.directBuffer.put(buffer, writtenSoFar, writeInThisCycle);
                this.directBuffer.flip();
                nwrite = fileChannel.write(this.directBuffer, cacheReadStart + (long)writtenSoFar);
                this.directBuffer.compact();
                writtenSoFar += nwrite;
            }
            this.warmupPenalty = (int)((long)this.warmupPenalty + (System.nanoTime() - start));
            log.debug((Object)("Read " + nread + " for file " + this.remotePath + " from offset " + cacheReadStart));
        }
        finally {
            buffer = null;
        }
        return nread;
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        try {
            log.debug((Object)("Updating cache for FileDownloadRequestChain . Num Requests : " + this.getReadRequests().size() + " for remotepath : " + remotePath));
            for (ReadRequest readRequest : this.getReadRequests()) {
                SetCachedRequest request = new SetCachedRequest(remotePath, fileSize, lastModified, this.toBlock(readRequest.getBackendReadStart()), this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L);
                this.bookKeeper.setAllCached(request);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not update BookKeeper about newly cached blocks: " + Throwables.getStackTraceAsString(e)));
        }
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setRequestedRead(this.totalRequestedRead).setWarmupPenalty(this.warmupPenalty).setRemoteReads(this.requests);
    }

    private long toBlock(long pos) {
        return pos / (long)this.blockSize;
    }
}

