/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.collect.Range;
import com.google.shaded.shaded.common.util.concurrent.MoreExecutors;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.DownloadRequestContext;
import com.qubole.rubix.bookkeeper.FileDownloadRequestChain;
import com.qubole.rubix.bookkeeper.utils.DiskUtils;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;

class FileDownloader {
    Configuration conf;
    private ExecutorService processService;
    int diskReadBufferSize;
    private MetricRegistry metrics;
    private Counter totalMBDownloaded;
    private Counter totalTimeToDownload;
    BookKeeper bookKeeper;
    private static final Log log = LogFactory.getLog(FileDownloader.class);
    private static DirectBufferPool bufferPool = new DirectBufferPool();

    public FileDownloader(BookKeeper bookKeeper, MetricRegistry metrics, Configuration conf) {
        this.bookKeeper = bookKeeper;
        this.conf = conf;
        this.metrics = metrics;
        int numThreads = CacheConfig.getRemoteFetchThreads(conf);
        this.diskReadBufferSize = CacheConfig.getDiskReadBufferSize(conf);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(numThreads);
        this.processService = MoreExecutors.getExitingExecutorService(executor);
        this.initializeMetrics();
    }

    private void initializeMetrics() {
        this.totalMBDownloaded = this.metrics.counter(BookKeeperMetrics.CacheMetric.ASYNC_DOWNLOADED_MB_COUNT.getMetricName());
        this.totalTimeToDownload = this.metrics.counter(BookKeeperMetrics.CacheMetric.ASYNC_DOWNLOAD_TIME_COUNT.getMetricName());
    }

    protected List<FileDownloadRequestChain> getFileDownloadRequestChains(ConcurrentMap<String, DownloadRequestContext> contextMap) throws IOException {
        ArrayList<FileDownloadRequestChain> readRequestChainList = new ArrayList<FileDownloadRequestChain>();
        for (Map.Entry entry : contextMap.entrySet()) {
            Path path = new Path((String)entry.getKey());
            DownloadRequestContext context = (DownloadRequestContext)entry.getValue();
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
            fs.initialize(path.toUri(), this.conf);
            String localPath = CacheUtil.getLocalPath((String)entry.getKey(), this.conf);
            log.debug((Object)("Processing Request for File : " + path.toString() + " LocalFile : " + localPath));
            ByteBuffer directWriteBuffer = bufferPool.getBuffer(this.diskReadBufferSize);
            FileDownloadRequestChain requestChain = new FileDownloadRequestChain(this.bookKeeper, fs, localPath, directWriteBuffer, this.conf, context.getRemoteFilePath(), context.getFileSize(), context.getLastModifiedTime());
            for (Range<Long> range : context.getRanges().asRanges()) {
                ReadRequest request = new ReadRequest(range.lowerEndpoint(), range.upperEndpoint(), range.lowerEndpoint(), range.upperEndpoint(), null, 0, context.getFileSize());
                requestChain.addReadRequest(request);
            }
            log.debug((Object)("Request added for file: " + requestChain.getRemotePath() + " Number of Requests : " + requestChain.getReadRequests().size()));
            readRequestChainList.add(requestChain);
        }
        return readRequestChainList;
    }

    protected long processDownloadRequests(List<FileDownloadRequestChain> readRequestChainList) {
        if (readRequestChainList.size() == 0) {
            return 0L;
        }
        long sizeRead = 0L;
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (FileDownloadRequestChain fileDownloadRequestChain : readRequestChainList) {
            fileDownloadRequestChain.lock();
            Future<Integer> result = this.processService.submit(fileDownloadRequestChain);
            futures.add(result);
        }
        for (Future future : futures) {
            FileDownloadRequestChain requestChain = readRequestChainList.get(futures.indexOf(future));
            long totalBytesToBeDownloaded = 0L;
            for (ReadRequest request : requestChain.getReadRequests()) {
                totalBytesToBeDownloaded += (long)request.getBackendReadLength();
            }
            try {
                long read = ((Integer)future.get()).intValue();
                if (read == totalBytesToBeDownloaded) {
                    requestChain.updateCacheStatus(requestChain.getRemotePath(), requestChain.getFileSize(), requestChain.getLastModified(), CacheConfig.getBlockSize(this.conf), this.conf);
                    sizeRead += read;
                    this.totalTimeToDownload.inc(requestChain.getTimeSpentOnDownload());
                    continue;
                }
                log.error((Object)("ReadData didn't match with requested value. RequestedData: " + totalBytesToBeDownloaded + " ReadData: " + read));
            }
            catch (InterruptedException | ExecutionException ex) {
                log.error((Object)ex);
                requestChain.cancel();
            }
        }
        long dataDownloadedInMB = DiskUtils.bytesToMB(sizeRead);
        this.totalMBDownloaded.inc(dataDownloadedInMB);
        return sizeRead;
    }
}

