/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.RemovalCause;
import com.google.shaded.shaded.common.util.concurrent.Striped;
import com.qubole.rubix.bookkeeper.ByteBufferBitmap;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class FileMetadata {
    private String remotePath;
    private String localPath;
    private String mdFilePath;
    private long size;
    private long lastModified;
    private long currentFileSize;
    private boolean needsRefresh = true;
    int bitmapFileSizeBytes;
    ByteBufferBitmap blockBitmap;
    static Striped<Lock> stripes = Striped.lock(20000);
    private static Log log = LogFactory.getLog((String)FileMetadata.class.getName());

    public FileMetadata() {
    }

    public FileMetadata(String remotePath, long fileLength, long lastModified, long currentFileSize, Configuration conf) throws IOException {
        this.remotePath = remotePath;
        this.size = fileLength;
        this.lastModified = lastModified;
        this.currentFileSize = currentFileSize;
        this.localPath = CacheUtil.getLocalPath(remotePath, conf);
        this.mdFilePath = CacheUtil.getMetadataFilePath(remotePath, conf);
        int bitsRequired = (int)Math.ceil((double)this.size / (double)CacheConfig.getBlockSize(conf));
        this.bitmapFileSizeBytes = (int)Math.ceil((double)bitsRequired / 8.0);
    }

    long incrementCurrentFileSize(long incrementBy) {
        this.currentFileSize += incrementBy;
        return this.currentFileSize;
    }

    public void setNeedsRefresh() {
        this.needsRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshBitmap() throws IOException {
        byte[] bytes = new byte[this.bitmapFileSizeBytes];
        Lock lock = stripes.get(this.remotePath);
        try {
            RandomAccessFile mdFile;
            lock.lock();
            try {
                mdFile = new RandomAccessFile(this.mdFilePath, "rw");
                mdFile.readFully(bytes, 0, (int)mdFile.length());
            }
            catch (FileNotFoundException e) {
                File file = new File(this.mdFilePath);
                file.createNewFile();
                file.setWritable(true, false);
                file.setReadable(true, false);
                mdFile = new RandomAccessFile(file, "rw");
                mdFile.setLength(this.bitmapFileSizeBytes);
            }
            mdFile.close();
        }
        finally {
            lock.unlock();
        }
        this.blockBitmap = new ByteBufferBitmap(bytes);
        this.needsRefresh = false;
    }

    public boolean isBlockCached(long blockNumber) throws IOException {
        if (this.needsRefresh) {
            this.refreshBitmap();
        }
        return this.blockBitmap.isSet((int)blockNumber);
    }

    private void setBlockCached(long blockNumber) throws IOException {
        if (this.needsRefresh) {
            this.refreshBitmap();
        }
        this.blockBitmap.set((int)blockNumber);
    }

    public synchronized boolean setBlocksCached(long startBlock, long endBlock) throws IOException {
        for (long blockNum = startBlock; blockNum < endBlock; ++blockNum) {
            this.setBlockCached(blockNum);
        }
        try {
            RandomAccessFile mdFile = new RandomAccessFile(this.mdFilePath, "rw");
            mdFile.write(this.blockBitmap.getBytes());
            mdFile.close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Could not update mdfile for " + this.remotePath + ". Trying again"), (Throwable)e);
            try {
                this.refreshBitmap();
            }
            catch (IOException e1) {
                this.blockBitmap = new ByteBufferBitmap(new byte[this.bitmapFileSizeBytes]);
                log.error((Object)("Could not refresh mdfile in second try for " + this.remotePath), (Throwable)e);
            }
            log.warn((Object)("Updated mdfile successfully for " + this.remotePath));
        }
        catch (IOException e) {
            log.error((Object)("Could not update mdfile for " + this.remotePath), (Throwable)e);
            return false;
        }
        return true;
    }

    public void closeAndCleanup(RemovalCause cause, Cache cache) throws IOException {
        if (cause != RemovalCause.REPLACED) {
            log.warn((Object)("Evicting " + this.getRemotePath().toString() + " due to " + (Object)((Object)cause)));
            this.deleteFiles(cache);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @VisibleForTesting
    public String getMdFilePath() {
        return this.mdFilePath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getFileSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFiles(Cache<String, FileMetadata> cache) {
        Lock lock = stripes.get(this.getRemotePath());
        try {
            lock.lock();
            File mdFile = new File(this.mdFilePath);
            mdFile.delete();
            File localFile = new File(this.localPath);
            localFile.delete();
        }
        finally {
            lock.unlock();
        }
        FileMetadata newEntry = cache.getIfPresent(this.getRemotePath());
        if (newEntry != null) {
            newEntry.setNeedsRefresh();
        }
    }

    public int getWeight(Configuration conf) {
        return (int)(this.currentFileSize / 1024L / 1024L);
    }
}

