/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.util.concurrent.AbstractScheduledService;
import com.google.shaded.shaded.common.util.concurrent.MoreExecutors;
import com.google.shaded.shaded.common.util.concurrent.Service;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.validation.CachingValidator;
import com.qubole.rubix.bookkeeper.validation.FileValidator;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.HeartbeatRequest;
import com.qubole.rubix.spi.thrift.HeartbeatStatus;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.TException;

public class HeartbeatService
extends AbstractScheduledService {
    private Log log = LogFactory.getLog((String)HeartbeatService.class.getName());
    private final ScheduledExecutorService validatorExecutor = Executors.newSingleThreadScheduledExecutor();
    private final RetryingBookkeeperClient bookkeeperClient;
    private final int heartbeatInitialDelay;
    private final int heartbeatInterval;
    private final Configuration conf;
    private final BookKeeper bookKeeper;
    private final String masterHostname;
    private FileValidator fileValidator;
    private CachingValidator cachingValidator;

    public HeartbeatService(Configuration conf, MetricRegistry metrics, BookKeeperFactory bookKeeperFactory, BookKeeper bookKeeper) {
        this.conf = conf;
        this.bookKeeper = bookKeeper;
        this.heartbeatInitialDelay = CacheConfig.getHeartbeatInitialDelay(conf);
        this.heartbeatInterval = CacheConfig.getHeartbeatInterval(conf);
        this.masterHostname = ClusterUtil.getMasterHostname(conf);
        this.bookkeeperClient = this.initializeClientWithRetry(bookKeeperFactory);
        if (CacheConfig.isValidationEnabled(conf)) {
            this.cachingValidator = new CachingValidator(conf, bookKeeper, this.validatorExecutor);
            this.cachingValidator.startAsync();
            metrics.register(BookKeeperMetrics.ValidationMetric.CACHING_VALIDATION_SUCCESS_GAUGE.getMetricName(), new Gauge<Integer>(){

                @Override
                public Integer getValue() {
                    return HeartbeatService.this.cachingValidator.didValidationSucceed() ? 1 : 0;
                }
            });
            this.fileValidator = new FileValidator(conf, this.validatorExecutor);
            this.fileValidator.startAsync();
            metrics.register(BookKeeperMetrics.ValidationMetric.FILE_VALIDATION_SUCCESS_GAUGE.getMetricName(), new Gauge<Integer>(){

                @Override
                public Integer getValue() {
                    return HeartbeatService.this.fileValidator.didValidationSucceed() ? 1 : 0;
                }
            });
        }
    }

    private RetryingBookkeeperClient initializeClientWithRetry(BookKeeperFactory bookKeeperFactory) {
        int retryInterval = CacheConfig.getServiceRetryInterval(this.conf);
        int maxRetries = CacheConfig.getServiceMaxRetries(this.conf);
        return bookKeeperFactory.createBookKeeperClient(this.masterHostname, this.conf, maxRetries, retryInterval, true);
    }

    @Override
    protected void startUp() {
        this.log.info((Object)String.format("Starting service %s in thread %d", this.serviceName(), Thread.currentThread().getId()));
        this.addListener(new FailureListener(), MoreExecutors.directExecutor());
    }

    @Override
    protected void runOneIteration() {
        try {
            HeartbeatStatus status = CacheConfig.isValidationEnabled(this.conf) ? new HeartbeatStatus(this.fileValidator.didValidationSucceed(), this.cachingValidator.didValidationSucceed()) : new HeartbeatStatus();
            this.log.debug((Object)String.format("Sending heartbeat to %s", this.masterHostname));
            this.bookkeeperClient.handleHeartbeat(new HeartbeatRequest(InetAddress.getLocalHost().getCanonicalHostName(), status));
        }
        catch (IOException e) {
            this.log.error((Object)"Could not send heartbeat", (Throwable)e);
        }
        catch (TException te) {
            this.log.error((Object)String.format("Could not connect to master node [%s]; will reattempt on next heartbeat", this.masterHostname));
        }
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule(this.heartbeatInitialDelay, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    private class FailureListener
    extends Service.Listener {
        private FailureListener() {
        }

        @Override
        public void failed(Service.State from, Throwable failure) {
            super.failed(from, failure);
            HeartbeatService.this.log.error((Object)"Encountered a problem", failure);
        }
    }
}

