/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.DataTransferClientHelper;
import com.qubole.rubix.spi.DataTransferHeader;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.thrift.ReadDataRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.thrift.shaded.TException;

public class LocalDataTransferServer
extends Configured
implements Tool {
    private static Log log = LogFactory.getLog((String)LocalDataTransferServer.class.getName());
    private static Configuration conf;
    private static LocalServer localServer;
    private static MetricRegistry metrics;
    private static BookKeeperMetrics bookKeeperMetrics;

    private LocalDataTransferServer() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new LocalDataTransferServer(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        conf = this.getConf();
        LocalDataTransferServer.startServer(conf, new MetricRegistry());
        return 0;
    }

    public static void startServer(Configuration conf, MetricRegistry metricRegistry) {
        LocalDataTransferServer.startServer(conf, metricRegistry, null);
    }

    public static void startServer(Configuration conf, MetricRegistry metricRegistry, BookKeeper bookKeeper) {
        conf = new Configuration(conf);
        CacheConfig.setCacheDataEnabled(conf, false);
        CacheConfig.disableFSCaches(conf);
        metrics = metricRegistry;
        LocalDataTransferServer.registerMetrics(conf);
        localServer = new LocalServer(conf, bookKeeper);
        new Thread(localServer).start();
    }

    private static void registerMetrics(Configuration conf) {
        bookKeeperMetrics = new BookKeeperMetrics(conf, metrics);
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_GC_PREFIX.getMetricName(), new GarbageCollectorMetricSet());
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_THREADS_PREFIX.getMetricName(), new CachedThreadStatesGaugeSet(CacheConfig.getMetricsReportingInterval(conf), TimeUnit.MILLISECONDS));
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_MEMORY_PREFIX.getMetricName(), new MemoryUsageGaugeSet());
    }

    public static void stopServer() {
        LocalDataTransferServer.removeMetrics();
        if (localServer != null) {
            try {
                bookKeeperMetrics.close();
            }
            catch (IOException e) {
                log.error((Object)"Metrics reporters could not be closed", (Throwable)e);
            }
            localServer.stop();
        }
    }

    protected static void removeMetrics() {
        metrics.removeMatching(bookKeeperMetrics.getMetricsFilter());
    }

    @VisibleForTesting
    public static boolean isServerUp() {
        if (localServer != null) {
            return localServer.isAlive();
        }
        return false;
    }

    static class ClientServiceThread
    extends Thread {
        SocketChannel localDataTransferClient;
        Configuration conf;
        BookKeeperFactory bookKeeperFactory;

        ClientServiceThread(SocketChannel s, Configuration conf, BookKeeperFactory bookKeeperFactory) {
            this.localDataTransferClient = s;
            this.conf = conf;
            this.bookKeeperFactory = bookKeeperFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RetryingBookkeeperClient bookKeeperClient;
                log.debug((Object)("Connected to node - " + this.localDataTransferClient.getRemoteAddress()));
                ByteBuffer dataInfo = ByteBuffer.allocate(CacheConfig.getMaxHeaderSize(this.conf));
                int read = this.localDataTransferClient.read(dataInfo);
                if (read == -1) {
                    throw new Exception("Could not read data from Non-local node");
                }
                dataInfo.flip();
                DataTransferHeader header = DataTransferClientHelper.readHeaders(dataInfo);
                long offset = header.getOffset();
                int readLength = header.getReadLength();
                String remotePath = header.getFilePath();
                log.debug((Object)String.format("Trying to read from %s at offset %d and length %d for client %s", remotePath, offset, readLength, this.localDataTransferClient.getRemoteAddress()));
                try {
                    bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.conf);
                }
                catch (Exception e) {
                    throw new Exception("Could not create BookKeeper Client " + Throwables.getStackTraceAsString(e));
                }
                if (!CacheConfig.isParallelWarmupEnabled(this.conf)) {
                    ReadDataRequest readDataRequest = new ReadDataRequest(remotePath, offset, readLength, header.getFileSize(), header.getLastModified());
                    if (!bookKeeperClient.readData(readDataRequest)) {
                        throw new Exception("Could not cache data required by non-local node");
                    }
                } else {
                    long blockSize = CacheConfig.getBlockSize(this.conf);
                    long startBlock = offset / blockSize;
                    long endBlock = (offset + (long)(readLength - 1)) / blockSize + 1L;
                    CacheStatusRequest request = new CacheStatusRequest(remotePath, header.getFileSize(), header.getLastModified(), startBlock, endBlock);
                    List<BlockLocation> blockLocations = bookKeeperClient.getCacheStatus(request);
                    long blockNum = startBlock;
                    for (BlockLocation location : blockLocations) {
                        if (location.getLocation() != Location.CACHED) {
                            log.error((Object)String.format("The requested data for block %d of file %s in not in cache.  The data will be read from object store", blockNum, remotePath));
                            throw new Exception("The requested data in not in cache. The data will be read from object store");
                        }
                        ++blockNum;
                    }
                }
                int nread = this.readDataFromCachedFile(bookKeeperClient, remotePath, offset, readLength);
                if (bookKeeperClient != null) {
                    bookKeeperClient.close();
                }
                log.debug((Object)String.format("Done reading %d from %s at offset %d and length %d for client %s", nread, remotePath, offset, readLength, this.localDataTransferClient.getRemoteAddress()));
            }
            catch (Exception e) {
                try {
                    log.warn((Object)("Error in Local Data Transfer Server for client: " + this.localDataTransferClient.getRemoteAddress()), (Throwable)e);
                }
                catch (IOException e1) {
                    log.warn((Object)"Error in Local Data Transfer Server for client: ", (Throwable)e);
                }
                return;
            }
            finally {
                try {
                    this.localDataTransferClient.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error in Local Data Transfer Server: ", (Throwable)e);
                }
            }
        }

        private int readDataFromCachedFile(RetryingBookkeeperClient bookKeeperClient, String remotePath, long offset, int readLength) throws IOException, TException {
            FileChannel fc = null;
            int nread = 0;
            String filename = CacheUtil.getLocalPath(remotePath, this.conf);
            try {
                fc = new FileInputStream(filename).getChannel();
                int maxCount = CacheConfig.getLocalTransferBufferSize(this.conf);
                int lengthRemaining = readLength;
                long position = offset;
                if (fc.size() < (long)readLength) {
                    log.error((Object)String.format("File size is smaller than requested read. Invalidating corrupted cached file %s", remotePath));
                    bookKeeperClient.invalidateFileMetadata(remotePath);
                    throw new IOException("File size is smaller than requested read");
                }
                while (nread < readLength) {
                    if (maxCount > lengthRemaining) {
                        maxCount = lengthRemaining;
                    }
                    nread = (int)((long)nread + fc.transferTo(position + (long)nread, maxCount, this.localDataTransferClient));
                    lengthRemaining = readLength - nread;
                }
            }
            catch (FileNotFoundException ex) {
                log.error((Object)String.format("Could not create file channel for %s. Invalidating missing remote file %s", filename, remotePath));
                bookKeeperClient.invalidateFileMetadata(remotePath);
                throw new IOException(String.format("File not found %s ", filename));
            }
            finally {
                if (fc != null) {
                    fc.close();
                }
            }
            return nread;
        }
    }

    public static class LocalServer
    implements Runnable {
        static ServerSocketChannel listener;
        Configuration conf;
        BookKeeperFactory bookKeeperFactory;

        public LocalServer(Configuration conf, BookKeeper bookKeeper) {
            this(conf, new BookKeeperFactory(bookKeeper));
        }

        public LocalServer(Configuration conf, BookKeeperFactory bookKeeperFactory) {
            this.conf = conf;
            this.bookKeeperFactory = bookKeeperFactory;
        }

        @Override
        public void run() {
            int port = CacheConfig.getDataTransferServerPort(this.conf);
            ExecutorService threadPool = Executors.newCachedThreadPool();
            try {
                listener = ServerSocketChannel.open();
                listener.bind(new InetSocketAddress(port), Integer.MAX_VALUE);
                log.info((Object)("Started LocalDataTransferServer on port " + port));
                while (true) {
                    SocketChannel clientSocket = listener.accept();
                    ClientServiceThread cliThread = new ClientServiceThread(clientSocket, this.conf, this.bookKeeperFactory);
                    threadPool.execute(cliThread);
                }
            }
            catch (AsynchronousCloseException e) {
                log.warn((Object)"Stopping Local Transfer server", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error starting Local Transfer server", (Throwable)e);
            }
        }

        public boolean isAlive() {
            return listener.isOpen();
        }

        public void stop() {
            try {
                listener.close();
            }
            catch (IOException e) {
                log.error((Object)"Error stopping Local Transfer server", (Throwable)e);
            }
        }
    }
}

