/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.util.concurrent.AbstractScheduledService;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.DownloadRequestContext;
import com.qubole.rubix.bookkeeper.FetchRequest;
import com.qubole.rubix.bookkeeper.FileDownloadRequestChain;
import com.qubole.rubix.bookkeeper.FileDownloader;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.spi.CacheConfig;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class RemoteFetchProcessor
extends AbstractScheduledService {
    private Queue<FetchRequest> processQueue;
    private FileDownloader downloader;
    private MetricRegistry metrics;
    private Counter totalDownloadRequests;
    private Counter processedRequests;
    int processThreadInitalDelay;
    int processThreadInterval;
    long requestProcessDelay;
    private static final Log log = LogFactory.getLog(RemoteFetchProcessor.class);

    public RemoteFetchProcessor(BookKeeper bookKeeper, MetricRegistry metrics, Configuration conf) {
        conf = new Configuration(conf);
        CacheConfig.disableFSCaches(conf);
        CacheConfig.setCacheDataEnabled(conf, false);
        this.processQueue = new ConcurrentLinkedQueue<FetchRequest>();
        this.metrics = metrics;
        this.downloader = new FileDownloader(bookKeeper, metrics, conf);
        this.processThreadInitalDelay = CacheConfig.getProcessThreadInitialDelay(conf);
        this.processThreadInterval = CacheConfig.getProcessThreadInterval(conf);
        this.requestProcessDelay = CacheConfig.getRemoteFetchProcessInterval(conf);
        this.initializeMetrics();
    }

    FileDownloader getFileDownloaderInstance() {
        return this.downloader;
    }

    private void initializeMetrics() {
        this.totalDownloadRequests = this.metrics.counter(BookKeeperMetrics.CacheMetric.TOTAL_ASYNC_REQUEST_COUNT.getMetricName());
        this.processedRequests = this.metrics.counter(BookKeeperMetrics.CacheMetric.PROCESSED_ASYNC_REQUEST_COUNT.getMetricName());
        this.metrics.register(BookKeeperMetrics.CacheMetric.ASYNC_QUEUE_SIZE_GAUGE.getMetricName(), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return RemoteFetchProcessor.this.processQueue.size();
            }
        });
    }

    public void addToProcessQueue(String remotePath, long offset, int length, long fileSize, long lastModified) {
        long requestedTime = System.currentTimeMillis();
        FetchRequest request = new FetchRequest(remotePath, offset, length, fileSize, lastModified, requestedTime);
        this.processQueue.add(request);
        this.totalDownloadRequests.inc();
    }

    @Override
    protected void runOneIteration() throws Exception {
        long currentTime = System.currentTimeMillis();
        if (!this.processQueue.isEmpty()) {
            this.processRequest(currentTime);
        }
    }

    protected void processRequest(long currentTime) throws IOException, InterruptedException, ExecutionException {
        ConcurrentMap<String, DownloadRequestContext> contextMap = this.mergeRequests(currentTime);
        this.processRemoteFetchRequest(contextMap);
        contextMap.clear();
    }

    protected ConcurrentMap<String, DownloadRequestContext> mergeRequests(long currentTime) {
        FetchRequest request;
        ConcurrentHashMap<String, DownloadRequestContext> contextMap = new ConcurrentHashMap<String, DownloadRequestContext>();
        while (!this.processQueue.isEmpty() && currentTime - (request = this.processQueue.peek()).getRequestedTime() >= this.requestProcessDelay) {
            DownloadRequestContext context = new DownloadRequestContext(request.getRemotePath(), request.getFileSize(), request.getLastModified());
            if (!contextMap.containsKey(request.getRemotePath())) {
                contextMap.putIfAbsent(request.getRemotePath(), context);
            } else if (((DownloadRequestContext)contextMap.get(request.getRemotePath())).getLastModifiedTime() < request.getLastModified()) {
                contextMap.remove(request.getRemotePath());
                contextMap.putIfAbsent(request.getRemotePath(), context);
            } else if (((DownloadRequestContext)contextMap.get(request.getRemotePath())).getLastModifiedTime() > request.getLastModified()) {
                this.processQueue.remove();
                continue;
            }
            ((DownloadRequestContext)contextMap.get(request.getRemotePath())).addDownloadRange(request.getOffset(), request.getOffset() + (long)request.getLength());
            this.processQueue.remove();
            this.processedRequests.inc();
        }
        return contextMap;
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule(this.processThreadInitalDelay, this.processThreadInterval, TimeUnit.MILLISECONDS);
    }

    private void processRemoteFetchRequest(ConcurrentMap<String, DownloadRequestContext> contextMap) throws IOException, InterruptedException, ExecutionException {
        List<FileDownloadRequestChain> readRequestChainList = this.downloader.getFileDownloadRequestChains(contextMap);
        this.downloader.processDownloadRequests(readRequestChainList);
    }
}

