/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.base.Ticker;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.cache.CacheLoader;
import com.google.shaded.shaded.common.cache.LoadingCache;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.HeartbeatService;
import com.qubole.rubix.bookkeeper.exception.BookKeeperInitializationException;
import com.qubole.rubix.bookkeeper.exception.WorkerInitializationException;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.HeartbeatRequest;
import com.qubole.rubix.spi.thrift.NodeState;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class WorkerBookKeeper
extends BookKeeper {
    private static Log log = LogFactory.getLog(WorkerBookKeeper.class);
    private LoadingCache<String, List<ClusterNode>> nodeStateMap;
    private HeartbeatService heartbeatService;
    private BookKeeperFactory bookKeeperFactory;
    private String masterHostname;
    private RetryingBookkeeperClient client;

    public WorkerBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws BookKeeperInitializationException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker(), new BookKeeperFactory());
    }

    public WorkerBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, BookKeeperFactory factory) throws BookKeeperInitializationException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker(), factory);
    }

    public WorkerBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, Ticker ticker, BookKeeperFactory factory) throws BookKeeperInitializationException {
        super(conf, bookKeeperMetrics, ticker);
        this.bookKeeperFactory = factory == null ? new BookKeeperFactory(this) : factory;
        this.masterHostname = ClusterUtil.getMasterHostname(conf);
        this.initializeWorker(conf, this.metrics, ticker, factory);
    }

    private void initializeWorker(Configuration conf, MetricRegistry metrics, Ticker ticker, BookKeeperFactory factory) throws WorkerInitializationException {
        this.startHeartbeatService(conf, metrics, factory);
        this.initializeNodeStateCache(conf, ticker);
        int errorCount = 0;
        int waitInterval = CacheConfig.getClusterNodesFetchWaitInterval(conf);
        int maxRetries = CacheConfig.getClusterNodesFetchRetryCount(conf);
        while (this.nodeName == null || this.nodeName.isEmpty()) {
            try {
                this.setCurrentNodeName(conf);
            }
            catch (WorkerInitializationException ex) {
                if (++errorCount < maxRetries) {
                    try {
                        Thread.sleep(waitInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setCurrentNodeName(Configuration conf) throws WorkerInitializationException {
        String nodeHostAddress;
        String nodeHostName;
        if (CacheConfig.getCurrentNodeHostName(conf) != null) {
            this.nodeName = CacheConfig.getCurrentNodeHostName(conf);
            return;
        }
        try {
            nodeHostName = InetAddress.getLocalHost().getCanonicalHostName();
            nodeHostAddress = InetAddress.getLocalHost().getHostAddress();
            log.debug((Object)(" HostName : " + nodeHostName + " HostAddress : " + nodeHostAddress));
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Could not get nodeName", (Throwable)e);
            throw new WorkerInitializationException("Could not get NodeName ", e);
        }
        List<ClusterNode> nodeList = this.getClusterNodes();
        if (nodeList != null && nodeList.size() > 0) {
            HashSet<String> nodeSet = new HashSet<String>();
            for (ClusterNode node : nodeList) {
                if (node.nodeState != NodeState.ACTIVE) continue;
                nodeSet.add(node.nodeUrl);
            }
            if (nodeSet.contains(nodeHostName)) {
                this.nodeName = nodeHostName;
                return;
            }
            if (nodeSet.contains(nodeHostAddress)) {
                this.nodeName = nodeHostAddress;
                return;
            }
            String errorMessage = String.format("Could not find nodeHostName=%s nodeHostAddress=%s among cluster nodes=%s  provided by master bookkeeper", nodeHostName, nodeHostAddress, nodeList);
            log.error((Object)errorMessage);
            throw new WorkerInitializationException(errorMessage);
        }
        String errorMessage = String.format("Could not find nodeHostName=%s nodeHostAddress=%s among cluster nodes=%s  provided by master bookkeeper", nodeHostName, nodeHostAddress, nodeList);
        log.error((Object)errorMessage);
        throw new WorkerInitializationException(errorMessage);
    }

    private void initializeNodeStateCache(final Configuration conf, Ticker ticker) {
        int expiryPeriod = CacheConfig.getWorkerNodeInfoExpiryPeriod(conf);
        this.nodeStateMap = CacheBuilder.newBuilder().ticker(ticker).refreshAfterWrite(expiryPeriod, TimeUnit.SECONDS).build(new CacheLoader<String, List<ClusterNode>>(){

            @Override
            public List<ClusterNode> load(String s) throws Exception {
                if (WorkerBookKeeper.this.client == null) {
                    WorkerBookKeeper.this.client = WorkerBookKeeper.createBookKeeperClientWithRetry(WorkerBookKeeper.this.bookKeeperFactory, WorkerBookKeeper.this.masterHostname, conf);
                }
                try {
                    List<ClusterNode> list = WorkerBookKeeper.this.client.getClusterNodes();
                    return list;
                }
                catch (Exception e) {
                    WorkerBookKeeper.this.client.close();
                    throw e;
                }
                finally {
                    WorkerBookKeeper.this.client = null;
                }
            }
        });
    }

    @Override
    public void handleHeartbeat(HeartbeatRequest request) {
        throw new UnsupportedOperationException("Worker node should not handle heartbeat");
    }

    @Override
    public List<ClusterNode> getClusterNodes() {
        try {
            return this.nodeStateMap.get("nodes");
        }
        catch (Exception e) {
            log.error((Object)("Could not get node host name from cache with Exception : " + e));
            return null;
        }
    }

    void startHeartbeatService(Configuration conf, MetricRegistry metrics, BookKeeperFactory factory) {
        if (CacheConfig.isHeartbeatEnabled(conf) || !CacheConfig.isEmbeddedModeEnabled(conf)) {
            this.heartbeatService = new HeartbeatService(conf, metrics, factory, this);
            this.heartbeatService.startAsync();
        }
    }

    private static RetryingBookkeeperClient createBookKeeperClientWithRetry(BookKeeperFactory bookKeeperFactory, String hostName, Configuration conf) {
        int retryInterval = CacheConfig.getServiceRetryInterval(conf);
        int maxRetries = CacheConfig.getServiceMaxRetries(conf);
        return bookKeeperFactory.createBookKeeperClient(hostName, conf, maxRetries, retryInterval, false);
    }
}

