/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.utils;

import com.google.shaded.shaded.common.base.Charsets;
import com.google.shaded.shaded.common.hash.HashCode;
import com.google.shaded.shaded.common.hash.HashFunction;
import com.google.shaded.shaded.common.hash.Hashing;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.NodeState;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsistentHashUtil {
    private static Log log = LogFactory.getLog((String)ConsistentHashUtil.class.getName());

    private ConsistentHashUtil() {
    }

    public static String getHashedNodeForKey(List<ClusterNode> nodeList, String key) {
        int nodeIndex = ConsistentHashUtil.getNodeIndex(nodeList, key);
        return nodeList.get((int)nodeIndex).nodeUrl;
    }

    public static int getNodeIndex(List<ClusterNode> nodeList, String key) {
        HashFunction hf = Hashing.md5();
        HashCode hc = hf.hashString(key, Charsets.UTF_8);
        int nodeIndex = Hashing.consistentHash(hc, nodeList.size());
        nodeIndex = hc.asInt() % 2 == 0 ? ConsistentHashUtil.getNextRunningNodeIndex(nodeList, nodeIndex).intValue() : ConsistentHashUtil.getPreviousRunningNodeIndex(nodeList, nodeIndex).intValue();
        return nodeIndex;
    }

    private static Integer getNextRunningNodeIndex(List<ClusterNode> nodeList, int startIndex) {
        for (int i = startIndex; i < startIndex + nodeList.size(); ++i) {
            int index = i >= nodeList.size() ? i - nodeList.size() : i;
            NodeState nodeState = nodeList.get((int)index).nodeState;
            if (nodeState != NodeState.ACTIVE) continue;
            return index;
        }
        return null;
    }

    private static Integer getPreviousRunningNodeIndex(List<ClusterNode> nodeList, int startIndex) {
        NodeState nodeState;
        int i;
        for (i = startIndex; i >= 0; --i) {
            nodeState = nodeList.get((int)i).nodeState;
            if (nodeState != NodeState.ACTIVE) continue;
            return i;
        }
        for (i = nodeList.size() - 1; i > startIndex; --i) {
            nodeState = nodeList.get((int)i).nodeState;
            if (nodeState != NodeState.ACTIVE) continue;
            return i;
        }
        return null;
    }
}

