/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.validation;

import com.google.shaded.shaded.common.base.Joiner;
import com.google.shaded.shaded.common.primitives.Ints;
import com.google.shaded.shaded.common.util.concurrent.AbstractScheduledService;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.common.utils.DataGen;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.thrift.ReadDataRequest;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.TException;

public class CachingValidator
extends AbstractScheduledService {
    private Log log = LogFactory.getLog(CachingValidator.class);
    public static final String VALIDATOR_TEST_FILE_NAME = "rubixCachingTestFile";
    public static final String VALIDATOR_TEST_FILE_PATH = Joiner.on(File.separator).join(System.getProperty("java.io.tmpdir"), "rubixCachingTestFile", new Object[0]);
    public static final String VALIDATOR_TEST_FILE_PATH_WITH_SCHEME = "file://" + VALIDATOR_TEST_FILE_PATH;
    private static final int VALIDATOR_START_BLOCK = 0;
    private static final int VALIDATOR_END_BLOCK = 1;
    private static final int VALIDATOR_READ_OFFSET = 0;
    private static final int VALIDATOR_CLUSTER_TYPE = ClusterType.TEST_CLUSTER_MANAGER.ordinal();
    private final BookKeeper bookKeeper;
    private final ScheduledExecutorService validationExecutor;
    private final int cachingValidationInterval;
    private AtomicBoolean validationSuccess = new AtomicBoolean(true);

    public CachingValidator(Configuration conf, BookKeeper bookKeeper, ScheduledExecutorService validationExecutor) {
        this.bookKeeper = bookKeeper;
        this.validationExecutor = validationExecutor;
        this.cachingValidationInterval = CacheConfig.getCachingValidationInterval(conf);
    }

    @Override
    protected ScheduledExecutorService executor() {
        return this.validationExecutor;
    }

    @Override
    protected void runOneIteration() {
        this.validationSuccess.set(this.validateCachingBehavior());
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule(0L, this.cachingValidationInterval, TimeUnit.MILLISECONDS);
    }

    public boolean didValidationSucceed() {
        return this.validationSuccess.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateCachingBehavior() {
        try {
            DataGen.populateFile(VALIDATOR_TEST_FILE_PATH);
        }
        catch (IOException e) {
            this.log.error((Object)"Could not create temporary file for testing caching behavior", (Throwable)e);
            return false;
        }
        File tempFile = new File(VALIDATOR_TEST_FILE_PATH);
        long fileLength = tempFile.length();
        long readSize = tempFile.length();
        long fileLastModified = tempFile.lastModified();
        CacheStatusRequest request = new CacheStatusRequest(VALIDATOR_TEST_FILE_PATH_WITH_SCHEME, fileLength, fileLastModified, 0L, 1L);
        try {
            List<BlockLocation> locations = this.bookKeeper.getCacheStatus(request);
            if (locations.isEmpty() || locations.get(0).getLocation() != Location.LOCAL) {
                boolean bl = false;
                return bl;
            }
            boolean dataRead = this.bookKeeper.readData(new ReadDataRequest(VALIDATOR_TEST_FILE_PATH_WITH_SCHEME, 0L, Ints.checkedCast(readSize), fileLength, fileLastModified));
            if (!dataRead) {
                boolean bl = false;
                return bl;
            }
            locations = this.bookKeeper.getCacheStatus(request);
            if (locations.isEmpty() || locations.get(0).getLocation() != Location.CACHED) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (TException e) {
            this.log.error((Object)"Unable to validate caching behavior", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.bookKeeper.invalidateFileMetadata(VALIDATOR_TEST_FILE_PATH_WITH_SCHEME);
            tempFile.delete();
        }
    }
}

