/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.common.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.util.DirectBufferPool;

public class DataGen {
    private DataGen() {
    }

    public static String generateContent(int jump, int sizeMultiplier) {
        StringBuilder stringBuilder = new StringBuilder();
        char i = 'a';
        while (i <= 'z') {
            for (int j = 0; j < sizeMultiplier; ++j) {
                stringBuilder.append(i);
            }
            i = (char)(i + jump);
        }
        return stringBuilder.toString();
    }

    public static String generateContent(int jump) {
        return DataGen.generateContent(jump, 100);
    }

    public static String generateContent() {
        return DataGen.generateContent(1);
    }

    public static String getExpectedOutput(int size, int sizeMultiplier) {
        String expected = DataGen.generateContent(2, sizeMultiplier);
        return expected.substring(0, size);
    }

    public static String getExpectedOutput(int size) {
        return DataGen.getExpectedOutput(size, 100);
    }

    public static void populateFile(String filename) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename, false)));
        out.print(DataGen.generateContent());
        out.close();
    }

    public static void populateFile(String filename, int skip) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename, false)));
        out.print(DataGen.generateContent(skip));
        out.close();
    }

    public static long populateFile(String filename, int skip, int sizeMultiplier) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename, false)));
        String data = DataGen.generateContent(skip, sizeMultiplier);
        out.print(data);
        out.close();
        return data.length();
    }

    public static void writeZerosInFile(String filename, int start, int end) throws IOException {
        File file = new File(filename);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.seek(start);
        String s = "0";
        StandardCharsets.UTF_8.encode(s);
        for (int i = 0; i < end - start; ++i) {
            raf.writeBytes(s);
        }
        raf.close();
    }

    public static void truncateFile(String fileName, int newSize) {
        try (FileChannel fileChannel = new FileOutputStream(fileName, true).getChannel();){
            fileChannel.truncate(newSize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] readBytesFromFile(String path, int offset, int length) throws IOException {
        int transferBytes;
        RandomAccessFile raf = new RandomAccessFile(path, "r");
        FileInputStream fis = new FileInputStream(raf.getFD());
        DirectBufferPool bufferPool = new DirectBufferPool();
        ByteBuffer directBuffer = bufferPool.getBuffer(2000);
        byte[] result = new byte[length];
        FileChannel fileChannel = fis.getChannel();
        int leftToRead = length;
        for (int nread = 0; nread < length; nread += transferBytes) {
            int readInThisCycle = Math.min(leftToRead, directBuffer.capacity());
            directBuffer.clear();
            int nbytes = fileChannel.read(directBuffer, offset + nread);
            if (nbytes <= 0) break;
            directBuffer.flip();
            transferBytes = Math.min(readInThisCycle, nbytes);
            directBuffer.get(result, nread, transferBytes);
            leftToRead -= transferBytes;
        }
        return result;
    }
}

