/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.DirectReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CachedReadRequestChain
extends ReadRequestChain {
    private String remotePath;
    private int read;
    private FileSystem.Statistics statistics;
    private FileSystem remoteFileSystem;
    private DirectReadRequestChain directReadChain;
    private Configuration conf;
    private int directDataRead;
    private BookKeeperFactory factory;
    private ByteBuffer directBuffer;
    private int corruptedFileCount;
    private static final Log log = LogFactory.getLog(CachedReadRequestChain.class);

    public CachedReadRequestChain(FileSystem remoteFileSystem, String remotePath, ByteBuffer buffer, FileSystem.Statistics statistics, Configuration conf, BookKeeperFactory factory) {
        this.conf = conf;
        this.remotePath = remotePath;
        this.remoteFileSystem = remoteFileSystem;
        this.directBuffer = buffer;
        this.statistics = statistics;
        this.factory = factory;
    }

    @VisibleForTesting
    public CachedReadRequestChain(FileSystem remoteFileSystem, String remotePath, Configuration conf, BookKeeperFactory factory) {
        this(remoteFileSystem, remotePath, ByteBuffer.allocate(1024), null, conf, factory);
    }

    @VisibleForTesting
    public CachedReadRequestChain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Cached read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        if (this.readRequests.size() == 0) {
            return 0;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        RandomAccessFile raf = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fileChannel = null;
        boolean needsInvalidation = false;
        String localCachedFile = CacheUtil.getLocalPath(this.remotePath, this.conf);
        try {
            raf = new RandomAccessFile(localCachedFile, "r");
            fis = new FileInputStream(raf.getFD());
            fileChannel = fis.getChannel();
            for (ReadRequest readRequest : this.readRequests) {
                int nread;
                int transferBytes;
                if (this.cancelled) {
                    this.propagateCancel(this.getClass().getName());
                }
                int leftToRead = readRequest.getActualReadLength();
                log.debug((Object)String.format("Processing readrequest %d-%d, length %d", readRequest.actualReadStart, readRequest.actualReadEnd, leftToRead));
                for (nread = 0; nread < readRequest.getActualReadLength(); nread += transferBytes) {
                    int readInThisCycle = Math.min(leftToRead, this.directBuffer.capacity());
                    this.directBuffer.clear();
                    int nbytes = ((FileChannel)fileChannel).read(this.directBuffer, readRequest.getActualReadStart() + (long)nread);
                    if (nbytes <= 0) break;
                    this.directBuffer.flip();
                    transferBytes = Math.min(readInThisCycle, nbytes);
                    this.directBuffer.get(readRequest.getDestBuffer(), readRequest.getDestBufferOffset() + nread, transferBytes);
                    leftToRead -= transferBytes;
                }
                log.debug((Object)String.format("CachedFileRead copied data [%d - %d] at buffer offset %d", readRequest.getActualReadStart(), readRequest.getActualReadStart() + (long)nread, readRequest.getDestBufferOffset()));
                if (nread != readRequest.getActualReadLength()) {
                    needsInvalidation = true;
                    log.error((Object)String.format("Cached read length didn't match with requested read length for file %s.  Falling back reading from object store.", localCachedFile));
                    this.directDataRead = this.readFromRemoteFileSystem();
                    Integer n = this.directDataRead;
                    return n;
                }
                this.read += nread;
            }
            log.debug((Object)String.format("Read %d bytes from cached file", this.read));
        }
        catch (Exception ex) {
            log.error((Object)String.format("Fall back to read from object store for %s .Could not read data from cached file : ", localCachedFile), (Throwable)ex);
            needsInvalidation = true;
            this.directDataRead = this.readFromRemoteFileSystem();
            Integer n = this.directDataRead;
            return n;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (raf != null) {
                raf.close();
            }
            if (needsInvalidation) {
                ++this.corruptedFileCount;
                this.invalidateMetadata();
            }
            if (this.statistics != null) {
                this.statistics.incrementBytesRead((long)this.read);
            }
        }
        return this.read;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.directReadChain != null) {
            this.directReadChain.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateMetadata() {
        RetryingBookkeeperClient client = null;
        try {
            client = this.factory.createBookKeeperClient(this.conf);
            client.invalidateFileMetadata(this.remotePath);
        }
        catch (Exception e) {
            log.error((Object)("Could not Invalidate Corrupted File " + this.remotePath + " Error : "), (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                    client = null;
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not close bookkeeper client. Exception: ", (Throwable)ex);
            }
        }
    }

    private int readFromRemoteFileSystem() throws IOException {
        this.read = 0;
        FSDataInputStream inputStream = this.remoteFileSystem.open(new Path(this.remotePath));
        this.directReadChain = new DirectReadRequestChain(inputStream);
        for (ReadRequest readRequest : this.readRequests) {
            this.directReadChain.addReadRequest(readRequest);
        }
        this.directReadChain.lock();
        int directRead = this.directReadChain.call();
        inputStream.close();
        this.directReadChain = null;
        return directRead;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setDirectDataRead(this.directDataRead).setCachedDataRead(this.read).setCachedReads(this.requests).setCorruptedFileCount(this.corruptedFileCount);
    }
}

