/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Strings;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.core.CachingFileSystemStats;
import com.qubole.rubix.core.CachingInputStream;
import com.qubole.rubix.core.DummyModeCachingInputStream;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.shaded.TException;
import org.weakref.shaded.jmx.MBeanExporter;

public abstract class CachingFileSystem<T extends FileSystem>
extends FileSystem {
    private static final Log log = LogFactory.getLog(CachingFileSystem.class);
    protected T fs;
    private boolean cacheSkipped;
    private boolean isRubixSchemeUsed;
    private URI uri;
    private Path workingDir;
    private static CachingFileSystemStats statsMBean;
    public static BookKeeperFactory bookKeeperFactory;
    public static String statsMBeanBaseName;

    private Class<T> getTypeParameterClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public CachingFileSystem() {
        try {
            this.fs = (FileSystem)this.getTypeParameterClass().newInstance();
            if (bookKeeperFactory == null) {
                bookKeeperFactory = new BookKeeperFactory();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)"cannot instantiate base filesystem ", (Throwable)e);
            Throwables.propagate(e);
        }
    }

    public FileSystem getRemoteFileSystem() {
        return this.fs;
    }

    public static void setLocalBookKeeper(BookKeeperService.Iface bookKeeper, String statsMbeanSuffix) {
        bookKeeperFactory = new BookKeeperFactory(bookKeeper);
        if (!Strings.isNullOrEmpty(statsMbeanSuffix)) {
            String mBeanName = statsMBeanBaseName + "," + statsMbeanSuffix;
            MBeanExporter exporter = new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
            try {
                if (ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(statsMBeanBaseName))) {
                    exporter.unexport(statsMBeanBaseName);
                }
                if (!ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(mBeanName))) {
                    exporter.export(mBeanName, (Object)statsMBean);
                }
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Could not export stats mbean", (Throwable)e);
            }
        }
    }

    public abstract String getScheme();

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified((FileSystem)this);
        this.isRubixSchemeUsed = uri.getScheme().equals("rubix");
        URI originalUri = this.getOriginalURI(uri);
        this.fs.initialize(originalUri, conf);
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        FSDataInputStream inputStream = null;
        if (CacheUtil.skipCache(path.toString(), this.getConf())) {
            inputStream = this.fs.open(path, bufferSize);
            this.cacheSkipped = true;
            return inputStream;
        }
        Path originalPath = new Path(this.getOriginalURI(path.toUri()).getScheme(), path.toUri().getAuthority(), path.toUri().getPath());
        if (CacheConfig.isDummyModeEnabled(this.getConf())) {
            return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new DummyModeCachingInputStream(this, originalPath, this.getConf(), statsMBean, bookKeeperFactory, (FileSystem)this.fs, bufferSize, this.statistics), CacheConfig.getBlockSize(this.getConf())));
        }
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new CachingInputStream(this, originalPath, this.getConf(), statsMBean, bookKeeperFactory, (FileSystem)this.fs, bufferSize, this.statistics), CacheConfig.getBlockSize(this.getConf())));
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        return this.fs.create(path, fsPermission, b, i, i1, l, progressable);
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        return this.fs.append(path, i, progressable);
    }

    public boolean rename(Path path, Path path1) throws IOException {
        return this.fs.rename(path, path1);
    }

    public boolean delete(Path path) throws IOException {
        return this.fs.delete(path);
    }

    public boolean delete(Path path, boolean b) throws IOException {
        return this.fs.delete(path, b);
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        FileStatus[] files = this.fs.listStatus(path);
        for (int i = 0; i < files.length; ++i) {
            files[i].setPath(this.getRubixPath(files[i].getPath(), this.isRubixSchemeUsed));
        }
        return files;
    }

    public void setWorkingDirectory(Path path) {
        this.workingDir = path;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return this.fs.mkdirs(path, fsPermission);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        FileStatus originalStatus = this.fs.getFileStatus(path);
        originalStatus.setPath(this.getRubixPath(originalStatus.getPath(), this.isRubixSchemeUsed));
        return originalStatus;
    }

    private Path getRubixPath(Path remotePath, boolean isRubixSchemeUsed) {
        String remotePathScheme = remotePath.toUri().getScheme();
        if (remotePathScheme.equals(this.getScheme()) && isRubixSchemeUsed) {
            return new Path("rubix", remotePath.toUri().getAuthority(), remotePath.toUri().getPath());
        }
        return remotePath;
    }

    private URI getOriginalURI(URI actualURI) {
        String actualScheme = actualURI.getScheme();
        if (!actualScheme.equals("rubix")) {
            return actualURI;
        }
        return URI.create(this.getScheme() + "://" + actualURI.getAuthority());
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (this.cacheSkipped || CacheConfig.isEmbeddedModeEnabled(this.getConf()) && !bookKeeperFactory.isBookKeeperInitialized()) {
            return this.fs.getFileBlockLocations(file, start, len);
        }
        Configuration conf = this.getConf();
        long splitSize = CacheConfig.getCacheFileSplitSize(conf);
        if (file == null) {
            return null;
        }
        if (start >= 0L && len >= 0L) {
            if (file.getLen() < start) {
                return new BlockLocation[0];
            }
            try {
                BlockLocation[] blockLocations = new BlockLocation[(int)Math.ceil((double)file.getLen() / (double)splitSize)];
                int blockNumber = 0;
                RetryingBookkeeperClient client = bookKeeperFactory.createBookKeeperClient(conf);
                for (long i = 0L; i < file.getLen(); i += splitSize) {
                    String key;
                    String hostName;
                    long end = i + splitSize;
                    if (end > file.getLen()) {
                        end = file.getLen();
                    }
                    if ((hostName = client.getOwnerNodeForPath(key = file.getPath().toString() + i + end)) == null) {
                        return this.fs.getFileBlockLocations(file, start, len);
                    }
                    String[] name = new String[]{hostName};
                    String[] host = new String[]{hostName};
                    blockLocations[blockNumber++] = new BlockLocation(name, host, i, end - i);
                    log.debug((Object)String.format("BlockLocation %s %d %d %s ", file.getPath().toString(), i, end - i, host[0]));
                }
                return blockLocations;
            }
            catch (TException ex) {
                log.error((Object)"Error while getting Node HostName. Fallingback on RemoteFileSystem. ", (Throwable)ex);
                return this.fs.getFileBlockLocations(file, start, len);
            }
        }
        throw new IllegalArgumentException("Invalid start or len parameter");
    }

    static {
        statsMBeanBaseName = "rubix:name=stats";
        MBeanExporter exporter = new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
        statsMBean = new CachingFileSystemStats();
        try {
            if (!ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(statsMBeanBaseName))) {
                exporter.export(statsMBeanBaseName, (Object)statsMBean);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Could not load MBean");
        }
    }
}

