/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.qubole.rubix.core.ReadRequestChainStats;
import org.weakref.shaded.jmx.Managed;

public class CachingFileSystemStats {
    private ReadRequestChainStats stats = new ReadRequestChainStats();
    private int bytesInMb = 0x100000;

    public synchronized void addReadRequestChainStats(ReadRequestChainStats newStats) {
        this.stats = this.stats.add(newStats);
    }

    @Managed(description="Gets the total size in MB that was downloaded from Remote files")
    public double getReadFromRemote() {
        return (double)this.stats.getTotalDownloaded() / (double)this.bytesInMb;
    }

    @Managed(description="Gets the total size in MB that was read for non local splits")
    public double getNonLocalDataRead() {
        return (double)this.stats.getNonLocalDataRead() / (double)this.bytesInMb;
    }

    @Managed(description="Gets the total number of non local reads that were done")
    public long getNonLocalReads() {
        return this.stats.getNonLocalReads();
    }

    @Managed(description="Gets the extra  MB read from remote files due to block alignment")
    public double getExtraReadFromRemote() {
        return (double)this.stats.getExtraRead() / (double)this.bytesInMb;
    }

    @Managed(description="Gets the MB read from cache")
    public double getReadFromCache() {
        return (double)this.stats.getCachedDataRead() / (double)this.bytesInMb;
    }

    @Managed(description="Gets the total number of request going out to Remote")
    public long getRemoteReads() {
        return this.stats.getRemoteReads();
    }

    @Managed(description="Gets the total number of request served from cache")
    public long getCachedReads() {
        return this.stats.getCachedReads();
    }

    @Managed(description="Gets the time in seconds spent in copying data into cache buffers. This is aggregated across all threads hence not the apparent penalty")
    public long getWarmupPenalty() {
        return this.stats.getWarmupPenalty() / 1000000000L;
    }

    @Managed(description="Gets the total number corrupted files that have been invalidated")
    public int getCorruptedFileCount() {
        return this.stats.getCorruptedFileCount();
    }

    @Managed
    public double getHitRate() {
        return (double)this.stats.getCachedReads() / (double)(this.stats.getCachedReads() + this.stats.getRemoteReads());
    }

    @Managed
    public double getMissRate() {
        return (double)this.stats.getRemoteReads() / (double)(this.stats.getCachedReads() + this.stats.getRemoteReads());
    }
}

