/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;

public class DirectReadRequestChain
extends ReadRequestChain {
    FSDataInputStream inputStream;
    int totalRead;
    private static final Log log = LogFactory.getLog(DirectReadRequestChain.class);

    public DirectReadRequestChain(FSDataInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setRemoteReads(this.requests).setRequestedRead(this.totalRead);
    }

    @Override
    public Integer call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Direct read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        long startTime = System.currentTimeMillis();
        if (this.readRequests.size() == 0) {
            return 0;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        for (ReadRequest readRequest : this.readRequests) {
            int nread;
            int nbytes;
            if (this.cancelled) {
                this.propagateCancel(this.getClass().getName());
            }
            this.inputStream.seek(readRequest.actualReadStart);
            for (nread = 0; nread < readRequest.getActualReadLength(); nread += nbytes) {
                nbytes = this.inputStream.read(readRequest.getDestBuffer(), readRequest.getDestBufferOffset() + nread, readRequest.getActualReadLength() - nread);
                if (nbytes >= 0) continue;
                log.debug((Object)String.format("Returning Read %d bytes directly from remote, no caching", this.totalRead));
                return nread;
            }
            this.totalRead += nread;
        }
        log.debug((Object)String.format("Read %d bytes directly from remote, no caching", this.totalRead));
        log.debug((Object)("DirectReadRequest took : " + (System.currentTimeMillis() - startTime) + " msecs "));
        return this.totalRead;
    }
}

