/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.core.CachingFileSystemStats;
import com.qubole.rubix.core.CachingInputStream;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.shaded.transport.TTransportException;

public class DummyModeCachingInputStream
extends CachingInputStream {
    private static final Log log = LogFactory.getLog(DummyModeCachingInputStream.class);

    public DummyModeCachingInputStream(FileSystem parentFs, Path backendPath, Configuration conf, CachingFileSystemStats statsMbean, BookKeeperFactory bookKeeperFactory, FileSystem remoteFileSystem, int bufferSize, FileSystem.Statistics statistics) throws IOException {
        super(parentFs, backendPath, conf, statsMbean, bookKeeperFactory, remoteFileSystem, bufferSize, statistics);
    }

    @Override
    public long getPos() throws IOException {
        return this.getParentDataInputStream().getPos();
    }

    @Override
    public void seek(long pos) throws IOException {
        Preconditions.checkState(pos >= 0L, "Negative Position");
        this.getParentDataInputStream().seek(pos);
    }

    @Override
    public int read(final byte[] buffer, final int offset, final int length) throws IOException {
        final long initPos = this.getPos();
        final long initNextReadBlock = initPos / (long)this.blockSize;
        int read = this.readFullyDirect(buffer, offset, length);
        readService.execute(new Runnable(){

            @Override
            public void run() {
                try (RetryingBookkeeperClient client = DummyModeCachingInputStream.this.bookKeeperFactory.createBookKeeperClient(DummyModeCachingInputStream.this.conf);){
                    long endBlock = (initPos + (long)(length - 1)) / (long)DummyModeCachingInputStream.this.blockSize + 1L;
                    List<ReadRequestChain> readRequestChains = DummyModeCachingInputStream.this.setupReadRequestChains(buffer, offset, endBlock, length, initPos, initNextReadBlock, client);
                    DummyModeCachingInputStream.this.updateCacheAndStats(readRequestChains);
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
                catch (TTransportException e) {
                    log.warn((Object)"Could not create bookkeeper client", (Throwable)e);
                    throw Throwables.propagate(e);
                }
            }
        });
        return read;
    }
}

