/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.core.DirectReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.DataTransferClientHelper;
import com.qubole.rubix.spi.DataTransferHeader;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class NonLocalReadRequestChain
extends ReadRequestChain {
    long fileSize;
    String filePath;
    long lastModified;
    String remoteNodeName;
    Configuration conf;
    int totalRead;
    int directRead;
    FileSystem remoteFileSystem;
    public boolean strictMode;
    FileSystem.Statistics statistics;
    DirectReadRequestChain directReadChain;
    private static final Log log = LogFactory.getLog(NonLocalReadRequestChain.class);

    public NonLocalReadRequestChain(String remoteLocation, long fileSize, long lastModified, Configuration conf, FileSystem remoteFileSystem, String remotePath, boolean strictMode, FileSystem.Statistics statistics) {
        this.remoteNodeName = remoteLocation;
        this.remoteFileSystem = remoteFileSystem;
        this.lastModified = lastModified;
        this.filePath = remotePath;
        this.fileSize = fileSize;
        this.conf = conf;
        this.strictMode = strictMode;
        this.statistics = statistics;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setNonLocalReads(this.requests).setRequestedRead(this.directRead).setNonLocalDataRead(this.totalRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Integer call() throws Exception {
        log.debug((Object)String.format("Read Request threadName: %s, Non Local read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        if (this.readRequests.size() == 0) {
            return 0;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        for (ReadRequest readRequest : this.readRequests) {
            Integer n;
            SocketChannel dataTransferClient;
            if (this.cancelled) {
                this.propagateCancel(this.getClass().getName());
            }
            try {
                dataTransferClient = DataTransferClientHelper.createDataTransferClient(this.remoteNodeName, this.conf);
            }
            catch (Exception e) {
                log.warn((Object)("Could not create Data Transfer Client to node " + this.remoteNodeName), (Throwable)e);
                if (this.strictMode) {
                    throw Throwables.propagate(e);
                }
                return this.directReadRequest(this.readRequests.indexOf(readRequest));
            }
            int nread = 0;
            InputStream inStream = dataTransferClient.socket().getInputStream();
            ReadableByteChannel wrappedChannel = Channels.newChannel(inStream);
            ByteBuffer buf = DataTransferClientHelper.writeHeaders(this.conf, new DataTransferHeader(readRequest.getActualReadStart(), readRequest.getActualReadLength(), this.fileSize, this.lastModified, this.filePath));
            dataTransferClient.write(buf);
            int bytesread = 0;
            ByteBuffer dst = ByteBuffer.wrap(readRequest.destBuffer, readRequest.getDestBufferOffset(), readRequest.destBuffer.length - readRequest.getDestBufferOffset());
            while (bytesread != readRequest.getActualReadLength()) {
                nread = wrappedChannel.read(dst);
                bytesread += nread;
                this.totalRead += nread;
                if (nread == -1) {
                    this.totalRead -= bytesread;
                    throw new Exception("Error reading from Local Transfer Server");
                }
                dst.position(bytesread + readRequest.getDestBufferOffset());
            }
            log.debug((Object)String.format("Read %d bytes internally from node %s", this.totalRead, this.remoteNodeName));
            if (this.statistics != null) {
                this.statistics.incrementBytesRead((long)this.totalRead);
            }
            try {
                if (dataTransferClient == null) continue;
                dataTransferClient.close();
                dataTransferClient = null;
            }
            catch (IOException e) {
                log.warn((Object)("Error closing Data Transfer client : " + this.remoteNodeName), (Throwable)e);
            }
            continue;
            catch (SocketTimeoutException e) {
                if (this.strictMode) {
                    log.error((Object)(this.remoteNodeName + ": socket read timed out."), (Throwable)e);
                    throw Throwables.propagate(e);
                }
                log.warn((Object)(this.remoteNodeName + ": socket read timed out. Using direct reads"), (Throwable)e);
                n = this.directReadRequest(this.readRequests.indexOf(readRequest));
                log.debug((Object)String.format("Read %d bytes internally from node %s", this.totalRead, this.remoteNodeName));
                if (this.statistics != null) {
                    this.statistics.incrementBytesRead((long)this.totalRead);
                }
                try {
                    if (dataTransferClient != null) {
                        dataTransferClient.close();
                        dataTransferClient = null;
                    }
                }
                catch (IOException e2) {
                    log.warn((Object)("Error closing Data Transfer client : " + this.remoteNodeName), (Throwable)e2);
                }
                return n;
            }
            catch (Exception e2) {
                log.warn((Object)("Error reading data from node : " + this.remoteNodeName), (Throwable)e2);
                if (this.strictMode) {
                    throw Throwables.propagate(e2);
                }
                n = this.directReadRequest(this.readRequests.indexOf(readRequest));
                {
                    catch (Throwable throwable) {
                        log.debug((Object)String.format("Read %d bytes internally from node %s", this.totalRead, this.remoteNodeName));
                        if (this.statistics != null) {
                            this.statistics.incrementBytesRead((long)this.totalRead);
                        }
                        try {
                            if (dataTransferClient != null) {
                                dataTransferClient.close();
                                dataTransferClient = null;
                            }
                        }
                        catch (IOException e3) {
                            log.warn((Object)("Error closing Data Transfer client : " + this.remoteNodeName), (Throwable)e3);
                        }
                        throw throwable;
                    }
                }
                log.debug((Object)String.format("Read %d bytes internally from node %s", this.totalRead, this.remoteNodeName));
                if (this.statistics != null) {
                    this.statistics.incrementBytesRead((long)this.totalRead);
                }
                try {
                    if (dataTransferClient != null) {
                        dataTransferClient.close();
                        dataTransferClient = null;
                    }
                }
                catch (IOException e4) {
                    log.warn((Object)("Error closing Data Transfer client : " + this.remoteNodeName), (Throwable)e4);
                }
                return n;
            }
        }
        return this.totalRead;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.directReadChain != null) {
            this.directReadChain.cancel();
        }
    }

    private int directReadRequest(int index) throws Exception {
        FSDataInputStream inputStream = this.remoteFileSystem.open(new Path(this.filePath));
        this.directReadChain = new DirectReadRequestChain(inputStream);
        for (ReadRequest readRequest : this.readRequests.subList(index, this.readRequests.size())) {
            this.directReadChain.addReadRequest(readRequest);
        }
        this.directReadChain.lock();
        this.directRead = this.directReadChain.call();
        inputStream.close();
        this.directReadChain = null;
        return this.totalRead + this.directRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            RetryingBookkeeperClient bookKeeperClient = null;
            try {
                bookKeeperClient = new BookKeeperFactory().createBookKeeperClient(this.remoteNodeName, conf);
                for (ReadRequest readRequest : this.readRequests) {
                    long startBlock = this.toBlock(readRequest.getBackendReadStart());
                    long endBlock = this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L;
                    CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock);
                    bookKeeperClient.getCacheStatus(request);
                    bookKeeperClient.setAllCached(new SetCachedRequest(remotePath, fileSize, lastModified, startBlock, endBlock));
                }
            }
            catch (Exception e) {
                if (this.strictMode) {
                    throw Throwables.propagate(e);
                }
                log.error((Object)"Dummy Mode: Could not update Cache Status for Non-Local Read Request ", (Throwable)e);
            }
            finally {
                try {
                    if (bookKeeperClient != null) {
                        bookKeeperClient.close();
                    }
                }
                catch (IOException ex) {
                    log.error((Object)"Dummy Mode: Could not close bookkeeper client. Exception: ", (Throwable)ex);
                }
            }
        }
    }

    private long toBlock(long pos) {
        long blockSize = CacheConfig.getBlockSize(this.conf);
        return pos / blockSize;
    }
}

