/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.core.NonLocalReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.core.RemoteFetchRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.Location;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class NonLocalRequestChain
extends ReadRequestChain {
    private static final Log log = LogFactory.getLog(NonLocalRequestChain.class);
    String remoteNodeName;
    long fileSize;
    long lastModified;
    Configuration conf;
    FileSystem remoteFileSystem;
    String remoteFilePath;
    int blockSize;
    boolean strictMode;
    BookKeeperFactory bookKeeperFactory;
    RetryingBookkeeperClient bookKeeperClient;
    NonLocalReadRequestChain nonLocalReadRequestChain;
    RemoteFetchRequestChain remoteFetchRequestChain;
    FileSystem.Statistics statistics;
    boolean needDirectReadRequest;
    List<BlockLocation> isCached;
    long startBlockForCacheStatus;
    long endBlockForCacheStatus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonLocalRequestChain(String remoteNodeName, long fileSize, long lastModified, Configuration conf, FileSystem remoteFileSystem, String remoteFilePath, boolean strictMode, FileSystem.Statistics statistics, long startBlock, long endBlock, BookKeeperFactory bookKeeperFactory) {
        this.remoteNodeName = remoteNodeName;
        this.remoteFileSystem = remoteFileSystem;
        this.lastModified = lastModified;
        this.remoteFilePath = remoteFilePath;
        this.fileSize = fileSize;
        this.conf = conf;
        this.strictMode = strictMode;
        this.statistics = statistics;
        this.startBlockForCacheStatus = startBlock;
        this.endBlockForCacheStatus = endBlock;
        this.bookKeeperFactory = bookKeeperFactory;
        this.blockSize = CacheConfig.getBlockSize(conf);
        try {
            this.bookKeeperClient = bookKeeperFactory.createBookKeeperClient(remoteNodeName, conf);
            log.debug((Object)(" Trying to getCacheStatus from : " + remoteNodeName + " for file : " + remoteFilePath + " StartBlock : " + startBlock + " EndBlock : " + endBlock));
            CacheStatusRequest request = new CacheStatusRequest(remoteFilePath, fileSize, lastModified, startBlock, endBlock);
            this.isCached = this.bookKeeperClient.getCacheStatus(request);
            log.debug((Object)("Cache Status : " + this.isCached));
        }
        catch (Exception e) {
            if (strictMode) {
                throw Throwables.propagate(e);
            }
            log.error((Object)("Could not get cache status from bookkeeper server at " + remoteNodeName), (Throwable)e);
        }
        finally {
            try {
                if (this.bookKeeperClient != null) {
                    this.bookKeeperClient.close();
                    this.bookKeeperClient = null;
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not close BookKeeper client ", (Throwable)e);
            }
        }
    }

    @Override
    public ReadRequestChainStats getStats() {
        if (this.nonLocalReadRequestChain != null) {
            return new ReadRequestChainStats().setNonLocalReads(this.nonLocalReadRequestChain.requests);
        }
        return new ReadRequestChainStats();
    }

    @Override
    public void addReadRequest(ReadRequest readRequest) {
        long blockNum = readRequest.backendReadStart / (long)this.blockSize;
        if (!this.needDirectReadRequest(blockNum)) {
            this.needDirectReadRequest = false;
            if (this.nonLocalReadRequestChain == null) {
                this.nonLocalReadRequestChain = new NonLocalReadRequestChain(this.remoteNodeName, this.fileSize, this.lastModified, this.conf, this.remoteFileSystem, this.remoteFilePath, this.strictMode, this.statistics);
            }
            this.nonLocalReadRequestChain.addReadRequest(readRequest);
        } else {
            this.needDirectReadRequest = true;
            if (this.remoteFetchRequestChain == null) {
                this.remoteFetchRequestChain = new RemoteFetchRequestChain(this.remoteFilePath, this.remoteFileSystem, this.remoteNodeName, this.conf, this.lastModified, this.fileSize, this.bookKeeperFactory);
            }
            this.remoteFetchRequestChain.addReadRequest(readRequest);
        }
    }

    protected boolean needDirectReadRequest(long blockNum) {
        int idx = (int)(blockNum - this.startBlockForCacheStatus);
        return this.isCached == null || this.isCached.get(idx).getLocation() != Location.CACHED;
    }

    @Override
    public Integer call() throws Exception {
        log.debug((Object)String.format("Read Request threadName: %s, NonLocal Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        long startTime = System.currentTimeMillis();
        int nonLocalReadBytes = 0;
        boolean directReadBytes = false;
        log.debug((Object)"Executing NonLocalRequestChain ");
        if (this.nonLocalReadRequestChain != null) {
            this.nonLocalReadRequestChain.lock();
            nonLocalReadBytes += this.nonLocalReadRequestChain.call().intValue();
        }
        if (this.remoteFetchRequestChain != null) {
            this.remoteFetchRequestChain.call();
        }
        log.debug((Object)("NonLocalRequest took : " + (System.currentTimeMillis() - startTime) + " msecs "));
        return nonLocalReadBytes;
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            if (this.remoteFetchRequestChain == null || this.remoteFetchRequestChain.getReadRequests().isEmpty()) {
                return;
            }
            this.remoteFetchRequestChain.updateCacheStatus(remotePath, fileSize, lastModified, blockSize, conf);
        }
    }
}

