/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import java.util.Arrays;

public class ReadRequest {
    long backendReadStart;
    long backendReadEnd;
    long actualReadStart;
    long actualReadEnd;
    byte[] destBuffer;
    int destBufferOffset;
    long backendFileSize;

    public ReadRequest() {
    }

    public ReadRequest(long backendReadStart, long backendReadEnd, long actualReadStart, long actualReadEnd, byte[] destBuffer, int destBufferOffset, long backendFileSize) {
        this.backendReadStart = backendReadStart;
        this.backendReadEnd = backendReadEnd;
        this.actualReadStart = actualReadStart;
        this.actualReadEnd = actualReadEnd;
        this.destBuffer = destBuffer;
        this.destBufferOffset = destBufferOffset;
        this.backendFileSize = backendFileSize;
    }

    public long getBackendReadStart() {
        return this.backendReadStart;
    }

    public void setBackendReadStart(long backendReadStart) {
        this.backendReadStart = backendReadStart;
    }

    public long getBackendReadEnd() {
        return this.backendReadEnd;
    }

    public void setBackendReadEnd(long backendReadEnd) {
        this.backendReadEnd = backendReadEnd;
    }

    public long getActualReadStart() {
        return this.actualReadStart;
    }

    public void setActualReadStart(long actualReadStart) {
        this.actualReadStart = actualReadStart;
    }

    public long getActualReadEnd() {
        return this.actualReadEnd;
    }

    public void setActualReadEnd(long actualReadEnd) {
        this.actualReadEnd = actualReadEnd;
    }

    public byte[] getDestBuffer() {
        return this.destBuffer;
    }

    public void setDestBuffer(byte[] destBuffer) {
        this.destBuffer = destBuffer;
    }

    public int getDestBufferOffset() {
        return this.destBufferOffset;
    }

    public void setDestBufferOffset(int destBufferOffset) {
        this.destBufferOffset = destBufferOffset;
    }

    public long getBackendFileSize() {
        return this.backendFileSize;
    }

    public void setBackendFileSize(long backendFileSize) {
        this.backendFileSize = backendFileSize;
    }

    public int getActualReadLength() {
        return (int)(this.actualReadEnd - this.actualReadStart);
    }

    public int getBackendReadLength() {
        return (int)(this.backendReadEnd - this.backendReadStart);
    }

    public ReadRequest clone(boolean createNewBuffer) {
        ReadRequest otherRequest = new ReadRequest();
        otherRequest.backendReadStart = this.backendReadStart;
        otherRequest.backendReadEnd = this.backendReadEnd;
        otherRequest.actualReadStart = this.actualReadStart;
        otherRequest.actualReadEnd = this.actualReadEnd;
        otherRequest.destBuffer = createNewBuffer ? Arrays.copyOf(this.destBuffer, this.destBuffer.length) : this.destBuffer;
        otherRequest.destBufferOffset = this.destBufferOffset;
        otherRequest.backendFileSize = this.backendFileSize;
        return otherRequest;
    }
}

