/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChainStats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public abstract class ReadRequestChain
implements Callable<Integer> {
    List<ReadRequest> readRequests = new ArrayList<ReadRequest>();
    ReadRequest lastRequest;
    boolean isLocked;
    boolean cancelled;
    protected String threadName = Thread.currentThread().getName();
    protected long requests;
    private static final Log log = LogFactory.getLog(ReadRequestChain.class);

    public void addReadRequest(ReadRequest readRequest) {
        Preconditions.checkState(!this.isLocked, "Adding request to a locked chain");
        log.debug((Object)String.format("Request to add ReadRequest: [%d, %d, %d, %d, %d]", readRequest.getBackendReadStart(), readRequest.getBackendReadEnd(), readRequest.getActualReadStart(), readRequest.getActualReadEnd(), readRequest.getDestBufferOffset()));
        if (this.lastRequest == null) {
            this.addRequest(readRequest);
        } else if (this.lastRequest.getBackendReadEnd() == readRequest.getBackendReadStart()) {
            this.lastRequest.setBackendReadEnd(readRequest.getBackendReadEnd());
            this.lastRequest.setActualReadEnd(readRequest.getActualReadEnd());
            log.debug((Object)String.format("Updated last to: [%d, %d, %d, %d, %d]", this.lastRequest.getBackendReadStart(), this.lastRequest.getBackendReadEnd(), this.lastRequest.getActualReadStart(), this.lastRequest.getActualReadEnd(), this.lastRequest.getDestBufferOffset()));
        } else {
            this.addRequest(readRequest);
        }
        ++this.requests;
    }

    private void addRequest(ReadRequest readRequest) {
        this.readRequests.add(readRequest);
        this.lastRequest = readRequest;
        log.debug((Object)String.format("Added ReadRequest: [%d, %d, %d, %d, %d]", readRequest.getBackendReadStart(), readRequest.getBackendReadEnd(), readRequest.getActualReadStart(), readRequest.getActualReadEnd(), readRequest.getDestBufferOffset()));
    }

    public void lock() {
        this.isLocked = true;
    }

    public List<ReadRequest> getReadRequests() {
        return this.readRequests;
    }

    public abstract ReadRequestChainStats getStats();

    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected void propagateCancel(String className) throws IOException {
        throw new CancelledException(className + " Cancelled");
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private class CancelledException
    extends IOException {
        public CancelledException(String message) {
            super(message);
        }
    }
}

