/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.ReadDataRequest;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class RemoteFetchRequestChain
extends ReadRequestChain {
    private static final Log log = LogFactory.getLog(RemoteFetchRequestChain.class);
    String remotePath;
    FileSystem remoteFileSystem;
    String remoteNodeLocation;
    Configuration conf;
    BookKeeperFactory bookKeeperFactory;
    long lastModified;
    long fileSize;

    public RemoteFetchRequestChain(String remotePath, FileSystem remoteFileSystem, String remoteNodeLocation, Configuration conf, long lastModified, long fileSize, BookKeeperFactory bookKeeperFactory) {
        this.remotePath = remotePath;
        this.remoteFileSystem = remoteFileSystem;
        this.remoteNodeLocation = remoteNodeLocation;
        this.conf = conf;
        this.lastModified = lastModified;
        this.fileSize = fileSize;
        this.bookKeeperFactory = bookKeeperFactory;
    }

    @Override
    public Integer call() throws Exception {
        if (this.readRequests.size() == 0) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        RetryingBookkeeperClient client = null;
        try {
            client = this.bookKeeperFactory.createBookKeeperClient(this.remoteNodeLocation, this.conf);
            for (ReadRequest request : this.readRequests) {
                log.debug((Object)("RemoteFetchRequest from : " + this.remoteNodeLocation + " Start : " + request.backendReadStart + " of length " + request.getBackendReadLength()));
                client.readData(new ReadDataRequest(this.remotePath, request.backendReadStart, request.getBackendReadLength(), this.fileSize, this.lastModified));
            }
        }
        catch (Exception e) {
            log.info((Object)("Could not initiate parallel warmup in node " + this.remoteNodeLocation), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                    client = null;
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not close bookkeeper client. Exception: ", (Throwable)ex);
            }
        }
        log.debug((Object)("Send request to remote took " + (System.currentTimeMillis() - startTime) + " :msecs"));
        return 0;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setRemoteReads(this.requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            RetryingBookkeeperClient bookKeeperClient = null;
            try {
                bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.remoteNodeLocation, conf);
                for (ReadRequest readRequest : this.readRequests) {
                    long startBlock = this.toBlock(readRequest.getBackendReadStart());
                    long endBlock = this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L;
                    CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock);
                    bookKeeperClient.getCacheStatus(request);
                    bookKeeperClient.setAllCached(new SetCachedRequest(remotePath, fileSize, lastModified, startBlock, endBlock));
                }
            }
            catch (Exception e) {
                log.error((Object)"Dummy Mode: Could not update Cache Status for Remote Fetch Request ", (Throwable)e);
            }
            finally {
                try {
                    if (bookKeeperClient != null) {
                        bookKeeperClient.close();
                    }
                }
                catch (IOException ex) {
                    log.error((Object)"Dummy Mode: Could not close bookkeeper client. Exception: ", (Throwable)ex);
                }
            }
        }
    }

    private long toBlock(long pos) {
        long blockSize = CacheConfig.getBlockSize(this.conf);
        return pos / blockSize;
    }
}

