/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;

public class RemoteReadRequestChain
extends ReadRequestChain {
    final FSDataInputStream inputStream;
    private ByteBuffer directBuffer;
    private byte[] affixBuffer;
    private int totalPrefixRead;
    private int totalSuffixRead;
    private int totalRequestedRead;
    private long warmupPenalty;
    private int blockSize;
    private BookKeeperFactory bookKeeperFactory;
    private static final Log log = LogFactory.getLog(RemoteReadRequestChain.class);
    private String localFile;

    public RemoteReadRequestChain(FSDataInputStream inputStream, String localfile, ByteBuffer directBuffer, byte[] affixBuffer, BookKeeperFactory bookKeeperFactory) {
        this.inputStream = inputStream;
        this.directBuffer = directBuffer;
        this.affixBuffer = affixBuffer;
        this.blockSize = affixBuffer.length;
        this.localFile = localfile;
        this.bookKeeperFactory = bookKeeperFactory;
    }

    @VisibleForTesting
    public RemoteReadRequestChain(FSDataInputStream inputStream, String fileName) {
        this(inputStream, fileName, ByteBuffer.allocate(100), new byte[100], new BookKeeperFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Remote read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        if (this.readRequests.size() == 0) {
            return 0;
        }
        File file = new File(this.localFile);
        if (!file.exists()) {
            file.createNewFile();
            file.setWritable(true, false);
            file.setReadable(true, false);
        }
        try (FileChannel fileChannel = new FileOutputStream(new RandomAccessFile(file, "rw").getFD()).getChannel();){
            for (ReadRequest readRequest : this.readRequests) {
                if (this.cancelled) {
                    this.propagateCancel(this.getClass().getName());
                }
                log.debug((Object)String.format("Executing ReadRequest: [%d, %d, %d, %d, %d]", readRequest.getBackendReadStart(), readRequest.getBackendReadEnd(), readRequest.getActualReadStart(), readRequest.getActualReadEnd(), readRequest.getDestBufferOffset()));
                this.inputStream.seek(readRequest.backendReadStart);
                int prefixBufferLength = (int)(readRequest.getActualReadStart() - readRequest.getBackendReadStart());
                int suffixBufferLength = (int)(readRequest.getBackendReadEnd() - readRequest.getActualReadEnd());
                log.debug((Object)String.format("PrefixLength: %d SuffixLength: %d", prefixBufferLength, suffixBufferLength));
                if (prefixBufferLength > 0) {
                    log.debug((Object)String.format("Trying to Read %d bytes into prefix buffer", prefixBufferLength));
                    this.totalPrefixRead += this.readIntoBuffer(this.affixBuffer, 0, prefixBufferLength);
                    log.debug((Object)String.format("Read %d bytes into prefix buffer", prefixBufferLength));
                    this.copyIntoCache(fileChannel, this.affixBuffer, 0, prefixBufferLength, readRequest.backendReadStart);
                    log.debug((Object)String.format("Copied %d prefix bytes into cache", prefixBufferLength));
                }
                log.debug((Object)String.format("Trying to Read %d bytes into destination buffer", readRequest.getActualReadLength()));
                int readBytes = this.readIntoBuffer(readRequest.getDestBuffer(), readRequest.destBufferOffset, readRequest.getActualReadLength());
                log.debug((Object)String.format("Read %d bytes into destination buffer", readBytes));
                this.copyIntoCache(fileChannel, readRequest.destBuffer, readRequest.destBufferOffset, readBytes, readRequest.actualReadStart);
                log.debug((Object)String.format("Copied %d requested bytes into cache", readBytes));
                this.totalRequestedRead += readBytes;
                if (suffixBufferLength <= 0) continue;
                Preconditions.checkState(readBytes == readRequest.getActualReadLength(), "Actual read less than required, still requested for suffix");
                log.debug((Object)String.format("Trying to Read %d bytes into suffix buffer", suffixBufferLength));
                this.totalSuffixRead += this.readIntoBuffer(this.affixBuffer, 0, suffixBufferLength);
                log.debug((Object)String.format("Read %d bytes into suffix buffer", suffixBufferLength));
                this.copyIntoCache(fileChannel, this.affixBuffer, 0, suffixBufferLength, readRequest.actualReadEnd);
                log.debug((Object)String.format("Copied %d suffix bytes into cache", suffixBufferLength));
            }
            log.debug((Object)String.format("Read %d bytes from remote localFile, added %d to destination buffer", this.totalPrefixRead + this.totalRequestedRead + this.totalSuffixRead, this.totalRequestedRead));
            Integer n = this.totalRequestedRead;
            return n;
        }
    }

    private int readIntoBuffer(byte[] destBuffer, int destBufferOffset, int length) throws IOException {
        int nread;
        int nbytes;
        for (nread = 0; nread < length && (nbytes = this.inputStream.read(destBuffer, destBufferOffset + nread, length - nread)) >= 0; nread += nbytes) {
        }
        return nread;
    }

    private int copyIntoCache(FileChannel fileChannel, byte[] destBuffer, int destBufferOffset, int length, long cacheReadStart) throws IOException {
        int nwrite;
        log.debug((Object)String.format("Trying to copy [%d - %d] bytes into cache with offset %d into localFile %s", cacheReadStart, cacheReadStart + (long)length, destBufferOffset, this.localFile));
        long start = System.nanoTime();
        int writtenSoFar = 0;
        for (int leftToWrite = length; leftToWrite > 0; leftToWrite -= nwrite) {
            int writeInThisCycle = Math.min(leftToWrite, this.directBuffer.capacity());
            this.directBuffer.clear();
            this.directBuffer.put(destBuffer, destBufferOffset + writtenSoFar, writeInThisCycle);
            this.directBuffer.flip();
            nwrite = fileChannel.write(this.directBuffer, cacheReadStart + (long)writtenSoFar);
            writtenSoFar += nwrite;
        }
        this.warmupPenalty += System.nanoTime() - start;
        return writtenSoFar;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setPrefixRead(this.totalPrefixRead).setRequestedRead(this.totalRequestedRead).setSuffixRead(this.totalSuffixRead).setWarmupPenalty(this.warmupPenalty).setRemoteReads(this.requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        RetryingBookkeeperClient client = null;
        try {
            client = this.bookKeeperFactory.createBookKeeperClient(conf);
            for (ReadRequest readRequest : this.readRequests) {
                SetCachedRequest request = new SetCachedRequest(remotePath, fileSize, lastModified, this.toBlock(readRequest.getBackendReadStart()), this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L);
                client.setAllCached(request);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Could not update BookKeeper about newly cached blocks", (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                    client = null;
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not close bookkeeper client. Exception", (Throwable)ex);
            }
        }
    }

    private long toBlock(long pos) {
        return pos / (long)this.blockSize;
    }
}

