/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.hadoop2;

import com.google.shaded.common.shaded.base.Throwables;
import com.google.shaded.common.shaded.cache.CacheBuilder;
import com.google.shaded.common.shaded.cache.CacheLoader;
import com.google.shaded.common.shaded.cache.LoadingCache;
import com.google.shaded.common.shaded.collect.ImmutableList;
import com.qubole.rubix.hadoop2.Hadoop2ClusterManagerUtil;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.NodeState;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class Hadoop2ClusterManagerV2
extends ClusterManager {
    static LoadingCache<String, List<ClusterNode>> nodesCache;
    YarnConfiguration yconf;
    private Log log = LogFactory.getLog(Hadoop2ClusterManagerV2.class);

    @Override
    public void initialize(Configuration conf) {
        super.initialize(conf);
        this.yconf = new YarnConfiguration(conf);
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("rubix-get-nodes-thread");
                t.setDaemon(true);
                return t;
            }
        });
        nodesCache = CacheBuilder.newBuilder().refreshAfterWrite(this.getNodeRefreshTime(), TimeUnit.SECONDS).build(CacheLoader.asyncReloading(new CacheLoader<String, List<ClusterNode>>(){

            @Override
            public List<ClusterNode> load(String s) throws Exception {
                try {
                    ArrayList<ClusterNode> hosts = new ArrayList<ClusterNode>();
                    List<Hadoop2ClusterManagerUtil.Node> allNodes = Hadoop2ClusterManagerUtil.getAllNodes(Hadoop2ClusterManagerV2.this.yconf);
                    if (allNodes == null) {
                        return ImmutableList.of();
                    }
                    if (allNodes.isEmpty()) {
                        return ImmutableList.of(new ClusterNode(InetAddress.getLocalHost().getHostAddress(), NodeState.ACTIVE));
                    }
                    for (Hadoop2ClusterManagerUtil.Node node : allNodes) {
                        NodeState nodeState = Hadoop2ClusterManagerV2.getNodeState(node.getState());
                        hosts.add(new ClusterNode(node.getNodeHostName(), nodeState));
                    }
                    Hadoop2ClusterManagerV2.this.log.debug((Object)("Hostlist: " + ((Object)hosts).toString()));
                    return hosts;
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        }, executor));
    }

    private static NodeState getNodeState(String nodeState) {
        if (nodeState.equalsIgnoreCase("Running") || nodeState.equalsIgnoreCase("New") || nodeState.equalsIgnoreCase("Rebooted")) {
            return NodeState.ACTIVE;
        }
        return NodeState.INACTIVE;
    }

    @Override
    public List<ClusterNode> getNodes() {
        try {
            return nodesCache.get("nodeList");
        }
        catch (ExecutionException e) {
            this.log.error((Object)Throwables.getStackTraceAsString(e));
            return null;
        }
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.HADOOP2_CLUSTER_MANAGER;
    }
}

