/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.prestosql;

import com.google.shaded.shaded.common.base.Throwables;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.cache.CacheLoader;
import com.google.shaded.shaded.common.cache.LoadingCache;
import com.google.shaded.shaded.common.collect.ImmutableList;
import com.google.shaded.shaded.common.reflect.TypeToken;
import com.google.shaded.shaded.gson.Gson;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.ClusterNode;
import com.qubole.rubix.spi.thrift.NodeState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class PrestoClusterManager
extends ClusterManager {
    private int serverPort = 8081;
    private String serverAddress = "localhost";
    static LoadingCache<String, List<ClusterNode>> nodesCache;
    private Log log = LogFactory.getLog(PrestoClusterManager.class);
    public static String serverPortConf;

    @Override
    public void initialize(Configuration conf) {
        super.initialize(conf);
        this.serverPort = conf.getInt(serverPortConf, this.serverPort);
        this.serverAddress = ClusterUtil.getMasterHostname(conf);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        nodesCache = CacheBuilder.newBuilder().refreshAfterWrite(this.getNodeRefreshTime(), TimeUnit.SECONDS).build(CacheLoader.asyncReloading(new CacheLoader<String, List<ClusterNode>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ClusterNode> load(String s) throws Exception {
                try {
                    StringBuffer failedResponse;
                    StringBuffer allResponse;
                    block30: {
                        URL allNodesRequest = PrestoClusterManager.this.getNodeUrl();
                        URL failedNodesRequest = PrestoClusterManager.this.getFailedNodeUrl();
                        HttpURLConnection allHttpCon = (HttpURLConnection)allNodesRequest.openConnection();
                        allHttpCon.setConnectTimeout(500);
                        allHttpCon.setRequestMethod("GET");
                        int allNodesResponseCode = allHttpCon.getResponseCode();
                        allResponse = new StringBuffer();
                        failedResponse = new StringBuffer();
                        try {
                            if (allNodesResponseCode != 200) {
                                PrestoClusterManager.this.log.warn((Object)String.format("v1/node failed with code: setting this node as worker ", new Object[0]));
                                ImmutableList<ClusterNode> in = ImmutableList.of();
                                return in;
                            }
                            String inputLine = "";
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(allHttpCon.getInputStream()));){
                                while ((inputLine = in.readLine()) != null) {
                                    allResponse.append(inputLine);
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new IOException(e);
                        }
                        finally {
                            allHttpCon.disconnect();
                        }
                        HttpURLConnection failHttpConn = (HttpURLConnection)failedNodesRequest.openConnection();
                        failHttpConn.setConnectTimeout(500);
                        failHttpConn.setRequestMethod("GET");
                        int failedNodesResponseCode = failHttpConn.getResponseCode();
                        try {
                            if (failedNodesResponseCode != 200) break block30;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(failHttpConn.getInputStream()));){
                                String inputLine;
                                while ((inputLine = in.readLine()) != null) {
                                    failedResponse.append(inputLine);
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new IOException(e);
                        }
                        finally {
                            failHttpConn.disconnect();
                        }
                    }
                    Gson gson = new Gson();
                    Type type = new TypeToken<List<Stats>>(){}.getType();
                    List allNodes = (List)gson.fromJson(allResponse.toString(), type);
                    ImmutableList failedNodes = (ImmutableList)gson.fromJson(failedResponse.toString(), type);
                    if (allNodes.isEmpty()) {
                        return ImmutableList.of(new ClusterNode(InetAddress.getLocalHost().getHostAddress(), NodeState.ACTIVE));
                    }
                    if (failedNodes.isEmpty()) {
                        failedNodes = ImmutableList.of();
                    }
                    allNodes.removeAll(failedNodes);
                    ArrayList<ClusterNode> hosts = new ArrayList<ClusterNode>();
                    Iterator i$ = allNodes.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            if (!hosts.isEmpty()) return hosts;
                            hosts.add(new ClusterNode(InetAddress.getLocalHost().getHostAddress(), NodeState.ACTIVE));
                            return hosts;
                        }
                        Stats node = (Stats)i$.next();
                        hosts.add(new ClusterNode(node.getUri().getHost(), NodeState.ACTIVE));
                    }
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
        }, executor));
    }

    @Override
    public List<ClusterNode> getNodes() {
        try {
            return nodesCache.get("nodeList");
        }
        catch (ExecutionException e) {
            this.log.warn((Object)"Error fetching node list : ", (Throwable)e);
            return null;
        }
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.PRESTOSQL_CLUSTER_MANAGER;
    }

    public static void setPrestoServerPort(Configuration conf, int port) {
        conf.setInt(serverPortConf, port);
    }

    private URL getNodeUrl() throws MalformedURLException {
        return new URL("http://" + this.serverAddress + ":" + this.serverPort + "/v1/node");
    }

    private URL getFailedNodeUrl() throws MalformedURLException {
        return new URL("http://" + this.serverAddress + ":" + this.serverPort + "/v1/node/failed");
    }

    static {
        serverPortConf = "caching.fs.presto-server-port";
    }

    public static class Stats {
        URI uri;
        String lastResponseTime;

        public Stats() {
        }

        public Stats(URI uri, String lastResponseTime) {
            this.uri = uri;
            this.lastResponseTime = lastResponseTime;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setURI(URI uri) {
            this.uri = uri;
        }

        String getLastResponseTime() {
            return this.lastResponseTime;
        }

        public void setLastResponseTime(String lastResponseTime) {
            this.lastResponseTime = lastResponseTime;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Stats o = (Stats)other;
            if (!this.uri.equals(o.getUri())) {
                return false;
            }
            if (this.lastResponseTime != null && o.getLastResponseTime() != null) {
                return this.lastResponseTime.equals(o.getLastResponseTime());
            }
            return this.lastResponseTime == o.getLastResponseTime();
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.lastResponseTime);
        }
    }
}

