/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.LocalBookKeeperClient;
import com.qubole.rubix.spi.RetryingBookkeeperClient;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.transport.TSocket;
import org.apache.thrift.shaded.transport.TTransport;
import org.apache.thrift.shaded.transport.TTransportException;

public class BookKeeperFactory {
    BookKeeperService.Iface bookKeeper;
    private static Log log = LogFactory.getLog((String)BookKeeperFactory.class.getName());

    public BookKeeperFactory() {
    }

    public BookKeeperFactory(BookKeeperService.Iface bookKeeper) {
        if (bookKeeper != null) {
            this.bookKeeper = bookKeeper;
        }
    }

    public RetryingBookkeeperClient createBookKeeperClient(String host, Configuration conf) throws TTransportException {
        if (this.bookKeeper != null) {
            return new LocalBookKeeperClient(null, this.bookKeeper);
        }
        int socketTimeout = CacheConfig.getServerSocketTimeout(conf);
        int connectTimeout = CacheConfig.getServerConnectTimeout(conf);
        TSocket transport = new TSocket(host, CacheConfig.getBookKeeperServerPort(conf), socketTimeout, connectTimeout);
        ((TTransport)transport).open();
        RetryingBookkeeperClient retryingBookkeeperClient = new RetryingBookkeeperClient(transport, CacheConfig.getMaxRetries(conf));
        return retryingBookkeeperClient;
    }

    public RetryingBookkeeperClient createBookKeeperClient(String host, Configuration conf, int maxRetries, long retryInterval, boolean throwException) {
        for (int failedStarts = 1; failedStarts <= maxRetries; ++failedStarts) {
            try {
                return this.createBookKeeperClient(host, conf);
            }
            catch (TTransportException e) {
                log.warn((Object)String.format("Could not create bookkeeper client [%d/%d attempts]", failedStarts, maxRetries));
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        log.fatal((Object)"Ran out of retries to create bookkeeper client.");
        if (throwException) {
            throw new RuntimeException("Could not create bookkeeper client");
        }
        return null;
    }

    public boolean isBookKeeperInitialized() {
        return this.bookKeeper != null;
    }

    public RetryingBookkeeperClient createBookKeeperClient(Configuration conf) throws TTransportException {
        return this.createBookKeeperClient("localhost", conf);
    }
}

