/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.google.shaded.shaded.common.base.Charsets;
import com.google.shaded.shaded.common.base.Supplier;
import com.google.shaded.shaded.common.base.Suppliers;
import com.google.shaded.shaded.common.hash.HashCode;
import com.google.shaded.shaded.common.hash.HashFunction;
import com.google.shaded.shaded.common.hash.Hashing;
import com.qubole.rubix.spi.CacheConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CacheUtil {
    private static final Log log = LogFactory.getLog((String)CacheUtil.class.getName());

    private CacheUtil() {
    }

    public static void createCacheDirectories(Configuration conf) throws FileNotFoundException {
        List<String> dirPrefixList = CacheUtil.getDirPrefixList(conf);
        int maxDisks = CacheConfig.getCacheMaxDisks(conf);
        boolean parentDirectoryExists = false;
        for (String dirPrefix : dirPrefixList) {
            for (int i = 0; i < maxDisks; ++i) {
                String cacheParentDir = dirPrefix + i;
                if (!CacheUtil.exists(cacheParentDir)) continue;
                parentDirectoryExists = true;
                String cacheDirPath = cacheParentDir + "/" + CacheConfig.getCacheDataDirSuffix(conf);
                CacheUtil.createCacheDirectory(cacheDirPath, conf);
            }
        }
        if (!parentDirectoryExists) {
            for (String dirPrefix : dirPrefixList) {
                if (!CacheUtil.exists(dirPrefix)) continue;
                parentDirectoryExists = true;
                String cacheDirPath = dirPrefix + "/" + CacheConfig.getCacheDataDirSuffix(conf);
                CacheUtil.createCacheDirectory(cacheDirPath, conf);
            }
        }
        if (!parentDirectoryExists) {
            throw new FileNotFoundException(String.format("None of the cache parent directories exists", new Object[0]));
        }
    }

    public static int getCacheDiskCount(Configuration conf) {
        return CacheUtil.getCacheDiskPathsMap(conf).size();
    }

    public static HashMap<Integer, String> getCacheDiskPathsMap(final Configuration conf) {
        Supplier<HashMap<Integer, String>> diskPathMapSupplier = Suppliers.memoize(new Supplier<HashMap<Integer, String>>(){

            @Override
            public HashMap<Integer, String> get() {
                HashMap<Integer, String> dirPathMap = new HashMap<Integer, String>();
                List<String> dirPrefixList = CacheUtil.getDirPrefixList(conf);
                String dirSuffix = CacheConfig.getCacheDataDirSuffix(conf);
                int maxDisks = CacheConfig.getCacheMaxDisks(conf);
                int numDisks = 0;
                for (String dirPrefix : dirPrefixList) {
                    for (int i = 0; i < maxDisks; ++i) {
                        String cacheDirPath = dirPrefix + i + "/" + dirSuffix;
                        if (!CacheUtil.exists(cacheDirPath)) continue;
                        dirPathMap.put(numDisks, dirPrefix + i);
                        ++numDisks;
                    }
                }
                if (numDisks == 0) {
                    for (String dirPrefix : dirPrefixList) {
                        String cacheDirPath = dirPrefix + "/" + dirSuffix;
                        if (!CacheUtil.exists(cacheDirPath)) continue;
                        dirPathMap.put(numDisks, dirPrefix);
                        ++numDisks;
                    }
                }
                return dirPathMap;
            }
        });
        return diskPathMapSupplier.get();
    }

    public static String getDirPath(int dirIndex, Configuration conf) {
        HashMap<Integer, String> dirPrefixMap = CacheUtil.getCacheDiskPathsMap(conf);
        return dirPrefixMap.get(dirIndex);
    }

    public static String getLocalPath(String remotePath, Configuration conf) {
        String absLocation = CacheUtil.getDirectory(remotePath, conf);
        return absLocation + "/" + CacheUtil.getName(remotePath);
    }

    public static String getRemotePath(String localPath, Configuration conf) {
        String cacheSuffix = CacheConfig.getCacheDataDirSuffix(conf);
        int index = localPath.indexOf(cacheSuffix);
        String remotePath = localPath.substring(index + cacheSuffix.length() - 1);
        return remotePath;
    }

    public static String getMetadataFilePath(String remotePath, Configuration conf) {
        String absLocation = CacheUtil.getDirectory(remotePath, conf);
        return absLocation + "/" + CacheUtil.getName(remotePath) + CacheConfig.getCacheMetadataFileSuffix(conf);
    }

    public static boolean isMetadataFile(String filePath, Configuration conf) {
        return filePath.endsWith(CacheConfig.getCacheMetadataFileSuffix(conf));
    }

    public static boolean skipCache(String path, Configuration conf) {
        if (!CacheConfig.isCacheDataEnabled(conf)) {
            return true;
        }
        if (!CacheUtil.isLocationAllowedToCache(path, conf)) {
            return true;
        }
        if (!CacheUtil.isTableAllowedToCache(conf)) {
            return true;
        }
        return !CacheUtil.minColumnsSelected(conf);
    }

    private static void createCacheDirectory(String cacheDirPath, Configuration conf) {
        File cacheDir = new File(cacheDirPath);
        cacheDir.mkdirs();
        File parentFile = cacheDir;
        do {
            parentFile.setWritable(true, false);
        } while ((parentFile = parentFile.getParentFile()).getAbsolutePath().contains(CacheConfig.getCacheDataDirSuffix(conf).split("/")[1]));
    }

    private static boolean exists(String filePath) {
        return new File(filePath).exists();
    }

    private static String getDirectory(String remotePath, Configuration conf) {
        String parentPath;
        String relLocation = parentPath = CacheUtil.getParent(remotePath);
        if (parentPath.contains(":")) {
            URI parentUri = new Path(parentPath).toUri();
            StringBuilder sb = new StringBuilder();
            sb.append(parentUri.getAuthority() != null ? parentUri.getAuthority() : "");
            sb.append(parentUri.getPath() != null ? parentUri.getPath() : "");
            relLocation = sb.toString();
            if (relLocation.startsWith("/")) {
                relLocation = relLocation.substring(1);
            }
        }
        String absLocation = CacheUtil.getLocalDirFor(remotePath, conf) + relLocation;
        CacheUtil.createCacheDirectory(absLocation, conf);
        return absLocation;
    }

    public static List<String> getDirPrefixList(Configuration conf) {
        String cacheDirPrefixList = CacheConfig.getCacheDirPrefixList(conf);
        return Arrays.asList(cacheDirPrefixList.split("\\s*,\\s*"));
    }

    private static String getLocalDirFor(String remotePath, Configuration conf) {
        int numDisks = CacheUtil.getCacheDiskCount(conf);
        int numBuckets = 100 * numDisks;
        HashFunction hf = Hashing.murmur3_32();
        HashCode hc = hf.hashString(remotePath, Charsets.UTF_8);
        int bucket = Math.abs(hc.asInt()) % numBuckets;
        int dirNum = bucket / numDisks % numDisks;
        String dirname = CacheUtil.getDirPath(dirNum, conf) + CacheConfig.getCacheDataDirSuffix(conf);
        return dirname;
    }

    public static String getName(String remotePath) {
        return remotePath.contains("/") ? remotePath.substring(remotePath.lastIndexOf(47) + 1) : remotePath;
    }

    private static String getParent(String remotePath) {
        return remotePath.contains("/") ? remotePath.substring(0, remotePath.lastIndexOf(47)) : "";
    }

    private static boolean isLocationAllowedToCache(String path, Configuration conf) {
        String whitelist = CacheConfig.getCacheDataLocationWhitelist(conf);
        if (whitelist.length() > 0 && !path.matches(whitelist)) {
            return false;
        }
        String blacklist = CacheConfig.getCacheDataLocationBlacklist(conf);
        return blacklist.length() <= 0 || !path.matches(blacklist);
    }

    private static boolean isTableAllowedToCache(Configuration conf) {
        String table = CacheConfig.getCacheDataTable(conf);
        if (table == null || table.isEmpty()) {
            return true;
        }
        String whitelist = CacheConfig.getCacheDataTableWhitelist(conf);
        return whitelist.length() <= 0 || table.matches(whitelist);
    }

    private static boolean minColumnsSelected(Configuration conf) {
        return CacheConfig.getCacheDataMinColumns(conf) <= CacheConfig.getCacheDataChosenColumns(conf);
    }
}

