/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.DataTransferHeader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.hadoop.conf.Configuration;

public class DataTransferClientHelper {
    private DataTransferClientHelper() {
    }

    public static SocketChannel createDataTransferClient(String remoteNodeName, Configuration conf) throws IOException {
        InetSocketAddress sad = new InetSocketAddress(remoteNodeName, CacheConfig.getDataTransferServerPort(conf));
        SocketChannel sc = SocketChannel.open();
        sc.socket().setSoTimeout(CacheConfig.getClientReadTimeout(conf));
        sc.configureBlocking(true);
        sc.socket().connect(sad, CacheConfig.getServerConnectTimeout(conf));
        return sc;
    }

    public static ByteBuffer writeHeaders(Configuration conf, DataTransferHeader header) {
        ByteBuffer buf = ByteBuffer.allocate(CacheConfig.getMaxHeaderSize(conf));
        buf.putInt(header.getFilePath().length());
        buf.put(header.getFilePath().getBytes());
        buf.putLong(header.getOffset());
        buf.putInt(header.getReadLength());
        buf.putLong(header.getFileSize());
        buf.putLong(header.getLastModified());
        buf.flip();
        return buf;
    }

    public static DataTransferHeader readHeaders(ByteBuffer dataInfo) {
        byte[] fileBytes = new byte[dataInfo.getInt()];
        dataInfo.get(fileBytes);
        String remotePath = new String(fileBytes);
        return new DataTransferHeader(dataInfo.getLong(), dataInfo.getInt(), dataInfo.getLong(), dataInfo.getLong(), remotePath);
    }
}

