/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.HeartbeatRequest;
import com.qubole.rubix.spi.thrift.SetCachedRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.shaded.TException;
import org.apache.thrift.shaded.protocol.TBinaryProtocol;
import org.apache.thrift.shaded.transport.TTransport;

public class RetryingBookkeeperClient
extends BookKeeperService.Client
implements Closeable {
    private static final Log log = LogFactory.getLog(RetryingBookkeeperClient.class);
    private int maxRetries;
    TTransport transport;

    public RetryingBookkeeperClient(TTransport transport, int maxRetries) {
        super(new TBinaryProtocol(transport));
        this.transport = transport;
        this.maxRetries = maxRetries;
    }

    @Override
    public List<BlockLocation> getCacheStatus(final CacheStatusRequest request) throws TException {
        return this.retryConnection(new Callable<List<BlockLocation>>(){

            @Override
            public List<BlockLocation> call() throws TException {
                return RetryingBookkeeperClient.super.getCacheStatus(request);
            }
        });
    }

    @Override
    public void setAllCached(final SetCachedRequest request) throws TException {
        this.retryConnection(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RetryingBookkeeperClient.super.setAllCached(request);
                return null;
            }
        });
    }

    @Override
    public void handleHeartbeat(final HeartbeatRequest request) throws TException {
        this.retryConnection(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RetryingBookkeeperClient.super.handleHeartbeat(request);
                return null;
            }
        });
    }

    private <V> V retryConnection(Callable<V> callable) throws TException {
        for (int errors = 0; errors < this.maxRetries; ++errors) {
            try {
                if (!this.transport.isOpen()) {
                    this.transport.open();
                }
                return callable.call();
            }
            catch (Exception e) {
                log.warn((Object)"Error while connecting : ", (Throwable)e);
                if (!this.transport.isOpen()) continue;
                this.transport.close();
                continue;
            }
        }
        throw new TException();
    }

    @Override
    public void close() throws IOException {
        if (this.transport.isOpen()) {
            this.transport.close();
        }
    }
}

