/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.shaded;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.thrift.shaded.TBase;
import org.apache.thrift.shaded.TException;
import org.apache.thrift.shaded.protocol.TBinaryProtocol;
import org.apache.thrift.shaded.protocol.TProtocol;
import org.apache.thrift.shaded.protocol.TProtocolFactory;
import org.apache.thrift.shaded.transport.TIOStreamTransport;

public class TSerializer {
    private final ByteArrayOutputStream baos_ = new ByteArrayOutputStream();
    private final TIOStreamTransport transport_ = new TIOStreamTransport(this.baos_);
    private TProtocol protocol_;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.transport_);
    }

    public byte[] serialize(TBase base) throws TException {
        this.baos_.reset();
        base.write(this.protocol_);
        return this.baos_.toByteArray();
    }

    public String toString(TBase base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public String toString(TBase base) throws TException {
        return new String(this.serialize(base));
    }
}

