/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.shaded.jmx;

import com.google.shaded.shaded.inject.Inject;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.weakref.shaded.jmx.JmxException;
import org.weakref.shaded.jmx.MBean;
import org.weakref.shaded.jmx.MBeanBuilder;
import org.weakref.shaded.jmx.internal.guava.collect.ImmutableMap;
import org.weakref.shaded.jmx.internal.guava.collect.MapMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanExporter {
    private final MBeanServer server;
    private final Map<ObjectName, Object> exportedObjects;

    MBeanExporter() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    @Inject
    public MBeanExporter(MBeanServer server) {
        this.server = server;
        this.exportedObjects = new MapMaker().weakValues().makeMap();
    }

    public void export(String name, Object object) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxException(JmxException.Reason.MALFORMED_OBJECT_NAME, e.getMessage(), new Object[0]);
        }
        this.export(objectName, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ObjectName objectName, Object object) {
        try {
            MBeanBuilder builder = new MBeanBuilder(object);
            MBean mbean = builder.build();
            Map<ObjectName, Object> map = this.exportedObjects;
            synchronized (map) {
                if (this.exportedObjects.containsKey(objectName)) {
                    throw new JmxException(JmxException.Reason.INSTANCE_ALREADY_EXISTS, "key already exported", new Object[0]);
                }
                this.server.registerMBean(mbean, objectName);
                this.exportedObjects.put(objectName, object);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_ALREADY_EXISTS, e.getMessage(), new Object[0]);
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (NotCompliantMBeanException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void unexport(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxException(JmxException.Reason.MALFORMED_OBJECT_NAME, e.getMessage(), new Object[0]);
        }
        this.unexport(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(ObjectName objectName) {
        try {
            Map<ObjectName, Object> map = this.exportedObjects;
            synchronized (map) {
                this.server.unregisterMBean(objectName);
                this.exportedObjects.remove(objectName);
            }
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (InstanceNotFoundException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_NOT_FOUND, e.getMessage(), new Object[0]);
        }
    }

    @Deprecated
    public void unexportAll() {
        this.unexportAllAndReportMissing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> unexportAllAndReportMissing() {
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        Map<ObjectName, Object> map = this.exportedObjects;
        synchronized (map) {
            ArrayList<ObjectName> toRemove = new ArrayList<ObjectName>(this.exportedObjects.size());
            for (ObjectName objectName : this.exportedObjects.keySet()) {
                try {
                    this.server.unregisterMBean(objectName);
                    toRemove.add(objectName);
                }
                catch (InstanceNotFoundException e) {
                    toRemove.add(objectName);
                }
                catch (MBeanRegistrationException e) {
                    errors.put(objectName.toString(), e);
                }
            }
            this.exportedObjects.keySet().removeAll(toRemove);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getExportedObjects() {
        Map<ObjectName, Object> map = this.exportedObjects;
        synchronized (map) {
            ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
            for (Map.Entry<ObjectName, Object> entry : this.exportedObjects.entrySet()) {
                builder.put(entry.getKey().toString(), entry.getValue());
            }
            return builder.build();
        }
    }

    public static MBeanExporter withPlatformMBeanServer() {
        return new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
    }
}

