/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class DomainConverter {
    private DomainConverter() {
    }

    public static TupleDomain<IcebergColumnHandle> convertTupleDomainTypes(TupleDomain<IcebergColumnHandle> tupleDomain) {
        if (tupleDomain.isAll() || tupleDomain.isNone()) {
            return tupleDomain;
        }
        return TupleDomain.withColumnDomains((Map)Maps.transformValues((Map)((Map)tupleDomain.getDomains().get()), DomainConverter::translateDomain));
    }

    private static Domain translateDomain(Domain domain) {
        ValueSet valueSet = domain.getValues();
        Type type = domain.getType();
        if (type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType) {
            if (valueSet instanceof EquatableValueSet) {
                EquatableValueSet equatableValueSet = (EquatableValueSet)valueSet;
                Set values = (Set)equatableValueSet.getEntries().stream().map(value -> EquatableValueSet.ValueEntry.create((Type)value.getType(), (Object)DomainConverter.convertToMicros(type, (Long)value.getValue()))).collect(ImmutableSet.toImmutableSet());
                valueSet = new EquatableValueSet(equatableValueSet.getType(), equatableValueSet.isWhiteList(), values);
            } else if (valueSet instanceof SortedRangeSet) {
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (Range range : valueSet.getRanges().getOrderedRanges()) {
                    Marker high;
                    Marker low = range.getLow();
                    if (low.getValueBlock().isPresent()) {
                        Block value2 = Utils.nativeValueToBlock((Type)type, (Object)DomainConverter.convertToMicros(type, (Long)range.getLow().getValue()));
                        low = new Marker(range.getType(), Optional.of(value2), range.getLow().getBound());
                    }
                    if ((high = range.getHigh()).getValueBlock().isPresent()) {
                        Block value3 = Utils.nativeValueToBlock((Type)type, (Object)DomainConverter.convertToMicros(type, (Long)range.getHigh().getValue()));
                        high = new Marker(range.getType(), Optional.of(value3), range.getHigh().getBound());
                    }
                    ranges.add(new Range(low, high));
                }
                valueSet = SortedRangeSet.copyOf((Type)valueSet.getType(), ranges);
            }
            return Domain.create((ValueSet)valueSet, (boolean)domain.isNullAllowed());
        }
        return domain;
    }

    private static long convertToMicros(Type type, long value) {
        if (type instanceof TimestampWithTimeZoneType || type instanceof TimeWithTimeZoneType) {
            return TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)value));
        }
        if (type instanceof TimestampType || type instanceof TimeType) {
            return TimeUnit.MILLISECONDS.toMicros(value);
        }
        throw new IllegalArgumentException(type + " is unsupported");
    }
}

